/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.CharArrayImmutableBlockBuffer;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;

public class CharArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements MutableBlockVolume {
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    private final BlockPalette palette;
    private final char[] blocks;

    public CharArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this(GlobalPalette.instance, new char[size.getX() * size.getY() * size.getZ()], start, size);
    }

    public CharArrayMutableBlockBuffer(char[] blocks, Vector3i start, Vector3i size) {
        this(GlobalPalette.instance, blocks, start, size);
    }

    public CharArrayMutableBlockBuffer(BlockPalette palette, Vector3i start, Vector3i size) {
        this(palette, new char[size.getX() * size.getY() * size.getZ()], start, size);
    }

    public CharArrayMutableBlockBuffer(BlockPalette palette, char[] blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.blocks = blocks;
        this.palette = palette;
    }

    @Override
    public BlockPalette getPalette() {
        return this.palette;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, Cause cause) {
        this.checkRange(x, y, z);
        this.blocks[this.getIndex((int)x, (int)y, (int)z)] = (char)this.palette.getOrAssign(block);
        return true;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        BlockState block = this.palette.get(this.blocks[this.getIndex(x, y, z)]).get();
        return block == null ? AIR : block;
    }

    @Override
    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform(this, transform);
    }

    @Override
    public MutableBlockVolumeWorker<? extends MutableBlockVolume> getBlockWorker(Cause cause) {
        return new SpongeMutableBlockVolumeWorker<CharArrayMutableBlockBuffer>(this, cause);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper(this);
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new CharArrayMutableBlockBuffer(this.palette, (char[])this.blocks.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBlockVolume getImmutableBlockCopy() {
        return new CharArrayImmutableBlockBuffer(this.blocks, this.start, this.size);
    }
}

