/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.common.util.gen.AbstractBiomeBuffer;
import org.spongepowered.common.util.gen.ObjectArrayImmutableBiomeBuffer;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements MutableBiomeVolume {
    private final Biome[] biomes;

    public ObjectArrayMutableBiomeBuffer(Biome[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return (BiomeType)this.biomes[this.getIndex(x, z)];
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"biome");
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)z)] = (Biome)biome;
    }

    @Override
    public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    public MutableBiomeVolumeWorker<? extends MutableBiomeVolume> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<ObjectArrayMutableBiomeBuffer>(this);
    }

    @Override
    public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ObjectArrayMutableBiomeBuffer((Biome[])this.biomes.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBiomeVolume getImmutableBiomeCopy() {
        return new ObjectArrayImmutableBiomeBuffer(this.biomes, this.start, this.size);
    }
}

