/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.persistence;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.MemoryDataView;

public class JsonTranslator {
    public static DataContainer translateFrom(JsonObject object) {
        return (DataContainer)JsonTranslator.convert((JsonElement)object);
    }

    private static Object convert(JsonElement element) {
        if (element.isJsonObject()) {
            MemoryDataContainer container = new MemoryDataContainer();
            for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                Object value = JsonTranslator.convert((JsonElement)entry.getValue());
                if (value == null) continue;
                ((MemoryDataView)container).set(DataQuery.of((String)entry.getKey()), value);
            }
            return container;
        }
        if (element.isJsonArray()) {
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((JsonArray)element), JsonTranslator::convert));
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
        }
        return null;
    }
}

