/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

public class SpongeChunkPreGenerate
implements WorldBorder.ChunkPreGenerate {
    private static final int DEFAULT_TICK_INTERVAL = 4;
    private static final float DEFAULT_TICK_PERCENT = 0.8f;
    private final World world;
    private final Vector3d center;
    private final double diameter;
    @Nullable
    private Object plugin = null;
    @Nullable
    private Logger logger = null;
    private int tickInterval = 4;
    private int chunkCount = 0;
    private float tickPercent = 0.8f;

    public SpongeChunkPreGenerate(World world, Vector3d center, double diameter) {
        this.world = world;
        this.center = center;
        this.diameter = diameter;
    }

    @Override
    public WorldBorder.ChunkPreGenerate owner(Object plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.plugin = plugin;
        return this;
    }

    @Override
    public WorldBorder.ChunkPreGenerate logger(@Nullable Logger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public WorldBorder.ChunkPreGenerate tickInterval(int tickInterval) {
        Preconditions.checkArgument((tickInterval > 0 ? 1 : 0) != 0, (Object)"tickInterval must be greater than zero");
        this.tickInterval = tickInterval;
        return this;
    }

    @Override
    public WorldBorder.ChunkPreGenerate chunksPerTick(int chunkCount) {
        this.chunkCount = chunkCount;
        return this;
    }

    @Override
    public WorldBorder.ChunkPreGenerate tickPercentLimit(float tickPercent) {
        Preconditions.checkArgument((tickPercent <= 1.0f ? 1 : 0) != 0, (Object)"tickPercent must be smaller or equal to 1");
        this.tickPercent = tickPercent;
        return this;
    }

    @Override
    public Task start() {
        Preconditions.checkNotNull((Object)this.plugin, (Object)"owner not set");
        Preconditions.checkArgument((this.chunkCount > 0 || this.tickPercent > 0.0f ? 1 : 0) != 0, (Object)"Must use at least one of \"chunks per tick\" or \"tick percent limit\"");
        return Task.builder().name(this.toString()).execute(new ChunkPreGenerator(this.world, this.center, this.diameter, this.chunkCount, this.tickPercent, this.logger)).intervalTicks(this.tickInterval).submit(this.plugin);
    }

    @Override
    public WorldBorder.ChunkPreGenerate from(Task value) {
        if (!(value instanceof SpongeChunkPreGenerate)) {
            throw new IllegalArgumentException("Not a chunk pre-gen task");
        }
        SpongeChunkPreGenerate other = (SpongeChunkPreGenerate)((Object)value);
        this.plugin = other.plugin;
        return this.logger(other.logger).tickInterval(other.tickInterval).chunksPerTick(other.chunkCount).tickPercentLimit(other.tickPercent);
    }

    @Override
    public WorldBorder.ChunkPreGenerate reset() {
        this.plugin = null;
        this.logger = null;
        this.tickInterval = 0;
        this.chunkCount = 0;
        this.tickPercent = 0.8f;
        return this;
    }

    public String toString() {
        return "SpongeChunkPreGen{center=" + this.center + ", diameter=" + this.diameter + ", plugin=" + this.plugin + ", world=" + this.world + ", tickInterval=" + this.tickInterval + ", chunkCount=" + this.chunkCount + ", tickPercent=" + this.tickPercent + '}';
    }

    private static class ChunkPreGenerator
    implements Consumer<Task> {
        private static final Vector3i[] OFFSETS = new Vector3i[]{Vector3i.UNIT_Z.negate().mul(2), Vector3i.UNIT_X.mul(2), Vector3i.UNIT_Z.mul(2), Vector3i.UNIT_X.negate().mul(2)};
        private static final String TIME_FORMAT = "s's 'S'ms'";
        private final World world;
        private final int chunkRadius;
        private final int chunkCount;
        private final float tickPercent;
        private final long tickTimeLimit;
        @Nullable
        private final Logger logger;
        private Vector3i currentPosition;
        private int currentGenCount;
        private int currentLayer;
        private int currentIndex;
        private int nextJump;
        private int totalCount;
        private long totalTime;

        ChunkPreGenerator(World world, Vector3d center, double diameter, int chunkCount, float tickPercent, @Nullable Logger logger) {
            this.world = world;
            this.chunkRadius = GenericMath.floor(diameter / 32.0);
            this.chunkCount = chunkCount;
            this.tickPercent = tickPercent;
            this.logger = logger;
            this.tickTimeLimit = Math.round((float)SpongeScheduler.getInstance().getPreferredTickInterval() * tickPercent);
            Optional<Vector3i> currentPosition = SpongeChunkLayout.instance.toChunk(center.toInt());
            if (!currentPosition.isPresent()) {
                throw new IllegalArgumentException("Center is not a valid chunk coordinate");
            }
            this.currentPosition = currentPosition.get();
            this.currentGenCount = 4;
            this.currentLayer = 0;
            this.currentIndex = 0;
            this.nextJump = 0;
            this.totalCount = 0;
            this.totalTime = 0L;
        }

        @Override
        public void accept(Task task) {
            long startTime = System.currentTimeMillis();
            int count = 0;
            do {
                count += this.currentGenCount;
                Vector3i position = this.nextChunkPosition();
                this.world.loadChunk(position, true);
                this.world.loadChunk(position.sub(Vector3i.UNIT_X), true);
                this.world.loadChunk(position.sub(Vector3i.UNIT_Z), true);
                this.world.loadChunk(position.sub(Vector3i.UNIT_X).sub(Vector3i.UNIT_Z), true);
            } while (this.hasNextChunkPosition() && this.checkChunkCount(count) && this.checkTickTime(System.currentTimeMillis() - startTime));
            if (this.logger != null) {
                this.totalCount += count;
                long deltaTime = System.currentTimeMillis() - startTime;
                this.totalTime += deltaTime;
                this.logger.info("Generated {} chunks in {}, {}% complete", count, DurationFormatUtils.formatDuration((long)deltaTime, (String)TIME_FORMAT, (boolean)false), GenericMath.floor((double)this.totalCount / Math.pow(this.chunkRadius * 2 + 1, 2.0) * 100.0));
            }
            if (!this.hasNextChunkPosition()) {
                if (this.logger != null) {
                    this.logger.info("Done! Generated a total of {} chunks in {}", (Object)this.totalCount, (Object)DurationFormatUtils.formatDuration((long)this.totalTime, (String)TIME_FORMAT, (boolean)false));
                }
                task.cancel();
            }
        }

        private boolean hasNextChunkPosition() {
            return this.currentLayer <= this.chunkRadius;
        }

        private Vector3i nextChunkPosition() {
            int currentLayerIndex;
            Vector3i nextPosition = this.currentPosition;
            if (this.currentIndex >= this.nextJump) {
                this.currentPosition = this.currentPosition.sub(Vector3i.UNIT_X).sub(Vector3i.UNIT_Z);
                ++this.currentLayer;
                this.nextJump += this.currentLayer * 4;
                currentLayerIndex = 1;
            } else {
                currentLayerIndex = this.currentIndex - (this.nextJump - this.currentLayer * 4);
                this.currentPosition = this.currentPosition.add(OFFSETS[currentLayerIndex / this.currentLayer]);
            }
            this.currentGenCount = currentLayerIndex % this.currentLayer == 0 ? 3 : 2;
            ++this.currentIndex;
            return nextPosition;
        }

        private boolean checkChunkCount(int count) {
            return this.chunkCount <= 0 || count < this.chunkCount;
        }

        private boolean checkTickTime(long tickTime) {
            return this.tickPercent <= 0.0f || tickTime < this.tickTimeLimit;
        }
    }
}

