/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import net.minecraft.world.Teleporter;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;

public class SpongePortalAgentType
implements PortalAgentType {
    private String name;
    private String id;
    private Class<? extends Teleporter> portalAgentClass;

    public SpongePortalAgentType(String name, String id, Class<? extends Teleporter> portalAgentClass) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.portalAgentClass = (Class)Preconditions.checkNotNull(portalAgentClass, (Object)("The portalAgent class was null! The name was: " + name));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends PortalAgent> getPortalAgentClass() {
        return this.portalAgentClass;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("class", (Object)this.portalAgentClass.getName()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PortalAgentType)) {
            return false;
        }
        PortalAgentType other = (PortalAgentType)obj;
        return this.name.equalsIgnoreCase(other.getName()) && this.portalAgentClass.equals(other.getPortalAgentClass());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

