/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.ByteArrayImmutableBiomeBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBlockBuffer;
import org.spongepowered.common.util.gen.CharArrayImmutableBlockBuffer;
import org.spongepowered.common.util.gen.CharArrayMutableBlockBuffer;
import org.spongepowered.common.util.gen.IntArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.ExtentBufferUtil;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.SpongeArchetypeVolume;

public interface DefaultedExtent
extends Extent {
    @Override
    default public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        if (!this.containsBiome(newMin.getX(), newMin.getY(), newMin.getZ())) {
            throw new PositionOutOfBoundsException(newMin, this.getBiomeMin(), this.getBiomeMax());
        }
        if (!this.containsBiome(newMax.getX(), newMin.getY(), newMax.getZ())) {
            throw new PositionOutOfBoundsException(newMax, this.getBiomeMin(), this.getBiomeMax());
        }
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    default public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    default public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    default public MutableBiomeVolume getBiomeCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBiomeBuffer(ExtentBufferUtil.copyToArray(this, this.getBiomeMin(), this.getBiomeMax(), this.getBiomeSize()), this.getBiomeMin(), this.getBiomeSize());
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    default public ImmutableBiomeVolume getImmutableBiomeCopy() {
        return ByteArrayImmutableBiomeBuffer.newWithoutArrayClone(ExtentBufferUtil.copyToArray(this, this.getBiomeMin(), this.getBiomeMax(), this.getBiomeSize()), this.getBiomeMin(), this.getBiomeSize());
    }

    @Override
    default public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        if (!this.containsBlock(newMin.getX(), newMin.getY(), newMin.getZ())) {
            throw new PositionOutOfBoundsException(newMin, this.getBlockMin(), this.getBlockMax());
        }
        if (!this.containsBlock(newMax.getX(), newMax.getY(), newMax.getZ())) {
            throw new PositionOutOfBoundsException(newMax, this.getBlockMin(), this.getBlockMax());
        }
        return new MutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    default public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform(this, transform);
    }

    @Override
    default public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper(this);
    }

    @Override
    default public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new CharArrayMutableBlockBuffer(ExtentBufferUtil.copyToArray(this, this.getBlockMin(), this.getBlockMax(), this.getBlockSize()), this.getBlockMin(), this.getBlockSize());
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    default public ImmutableBlockVolume getImmutableBlockCopy() {
        return CharArrayImmutableBlockBuffer.newWithoutArrayClone(ExtentBufferUtil.copyToArray(this, this.getBlockMin(), this.getBlockMax(), this.getBlockSize()), this.getBlockMin(), this.getBlockSize());
    }

    @Override
    default public MutableBiomeVolumeWorker<? extends Extent> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<DefaultedExtent>(this);
    }

    @Override
    default public MutableBlockVolumeWorker<? extends Extent> getBlockWorker(Cause cause) {
        return new SpongeMutableBlockVolumeWorker<DefaultedExtent>(this, cause);
    }

    @Override
    default public ArchetypeVolume createArchetypeVolume(Vector3i min, Vector3i max, Vector3i origin) {
        Vector3i tmin = min.min(max);
        Vector3i tmax = max.max(min);
        min = tmin;
        max = tmax;
        Extent volume = this.getExtentView(min, max);
        BimapPalette palette = new BimapPalette();
        volume.getBlockWorker(SpongeImpl.getImplementationCause()).iterate((v, x, y, z) -> palette.getOrAssign(v.getBlock(x, y, z)));
        int ox = origin.getX();
        int oy = origin.getY();
        int oz = origin.getZ();
        AbstractBlockBuffer backing = palette.getHighestId() <= 255 ? new ByteArrayMutableBlockBuffer(palette, min.sub(origin), max.sub(min).add(1, 1, 1)) : (palette.getHighestId() <= 65535 ? new CharArrayMutableBlockBuffer(palette, min.sub(origin), max.sub(min).add(1, 1, 1)) : new IntArrayMutableBlockBuffer(palette, min.sub(origin), max.sub(min).add(1, 1, 1)));
        HashMap tiles = Maps.newHashMap();
        volume.getBlockWorker(SpongeImpl.getImplementationCause()).iterate((arg_0, arg_1, arg_2, arg_3) -> DefaultedExtent.lambda$createArchetypeVolume$1((MutableBlockVolume)((Object)backing), ox, oy, oz, tiles, arg_0, arg_1, arg_2, arg_3));
        return new SpongeArchetypeVolume((MutableBlockVolume)((Object)backing), tiles);
    }

    private static /* synthetic */ void lambda$createArchetypeVolume$1(MutableBlockVolume backing, int ox, int oy, int oz, Map tiles, Extent extent, int x, int y, int z) {
        BlockState state = extent.getBlock(x, y, z);
        backing.setBlock(x - ox, y - oy, z - oz, state, SpongeImpl.getImplementationCause());
        Optional<TileEntity> tile = extent.getTileEntity(x, y, z);
        if (tile.isPresent()) {
            tiles.put(new Vector3i(x - ox, y - oy, z - oz), tile.get().createArchetype());
        }
    }
}

