/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent;

import com.flowpowered.math.vector.Vector3i;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.world.extent.BiomeVolume;
import org.spongepowered.api.world.extent.BlockVolume;

public class ExtentBufferUtil {
    public static byte[] copyToArray(BiomeVolume volume, Vector3i min, Vector3i max, Vector3i size) {
        long memory = (long)size.getX() * (long)size.getZ();
        if (memory > 0x7FFFFFF7L) {
            throw new OutOfMemoryError("Cannot copy the biomes to an array because the size limit was reached");
        }
        byte[] copy = new byte[(int)memory];
        int i = 0;
        for (int z = min.getZ(); z <= max.getZ(); ++z) {
            for (int x = min.getX(); x <= max.getX(); ++x) {
                copy[i++] = (byte)Biome.func_185362_a((Biome)((Biome)volume.getBiome(x, 0, z)));
            }
        }
        return copy;
    }

    public static char[] copyToArray(BlockVolume volume, Vector3i min, Vector3i max, Vector3i size) {
        long memory = (long)size.getX() * (long)size.getY() * (long)size.getZ();
        if (memory > 0x7FFFFFF7L) {
            throw new OutOfMemoryError("Cannot copy the blocks to an array because the size limit was reached");
        }
        char[] copy = new char[(int)memory];
        int i = 0;
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                for (int y = min.getY(); y <= max.getY(); ++y) {
                    copy[i++] = (char)Block.field_176229_d.func_148747_b((Object)((IBlockState)volume.getBlock(x, y, z)));
                }
            }
        }
        return copy;
    }
}

