/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent.worker;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.function.BiFunction;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.extent.BlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.BlockVolumeWorker;
import org.spongepowered.api.world.extent.worker.procedure.BlockVolumeMapper;
import org.spongepowered.api.world.extent.worker.procedure.BlockVolumeMerger;
import org.spongepowered.api.world.extent.worker.procedure.BlockVolumeReducer;
import org.spongepowered.api.world.extent.worker.procedure.BlockVolumeVisitor;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;

public class SpongeBlockVolumeWorker<V extends BlockVolume>
implements BlockVolumeWorker<V> {
    protected final V volume;
    protected final Cause cause;

    public SpongeBlockVolumeWorker(V volume, Cause cause) {
        this.volume = volume;
        this.cause = cause;
    }

    @Override
    public V getVolume() {
        return this.volume;
    }

    @Override
    public void map(BlockVolumeMapper mapper, MutableBlockVolume destination) {
        Vector3i offset = this.align(destination);
        int xOffset = offset.getX();
        int yOffset = offset.getY();
        int zOffset = offset.getZ();
        UnmodifiableBlockVolume unmodifiableVolume = this.volume.getUnmodifiableBlockView();
        int xMin = unmodifiableVolume.getBlockMin().getX();
        int yMin = unmodifiableVolume.getBlockMin().getY();
        int zMin = unmodifiableVolume.getBlockMin().getZ();
        int xMax = unmodifiableVolume.getBlockMax().getX();
        int yMax = unmodifiableVolume.getBlockMax().getY();
        int zMax = unmodifiableVolume.getBlockMax().getZ();
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().switchToPhase(PluginPhase.State.BLOCK_WORKER, PhaseContext.start().add(NamedCause.source(this)).addCaptures().complete());
        }
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    BlockState block = mapper.map(unmodifiableVolume, x, y, z);
                    destination.setBlock(x + xOffset, y + yOffset, z + zOffset, block, this.cause);
                }
            }
        }
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().completePhase(PluginPhase.State.BLOCK_WORKER);
        }
    }

    @Override
    public void merge(BlockVolume second, BlockVolumeMerger merger, MutableBlockVolume destination) {
        Vector3i offsetSecond = this.align(second);
        int xOffsetSecond = offsetSecond.getX();
        int yOffsetSecond = offsetSecond.getY();
        int zOffsetSecond = offsetSecond.getZ();
        Vector3i offsetDestination = this.align(destination);
        int xOffsetDestination = offsetDestination.getX();
        int yOffsetDestination = offsetDestination.getY();
        int zOffsetDestination = offsetDestination.getZ();
        UnmodifiableBlockVolume firstUnmodifiableVolume = this.volume.getUnmodifiableBlockView();
        int xMin = firstUnmodifiableVolume.getBlockMin().getX();
        int yMin = firstUnmodifiableVolume.getBlockMin().getY();
        int zMin = firstUnmodifiableVolume.getBlockMin().getZ();
        int xMax = firstUnmodifiableVolume.getBlockMax().getX();
        int yMax = firstUnmodifiableVolume.getBlockMax().getY();
        int zMax = firstUnmodifiableVolume.getBlockMax().getZ();
        UnmodifiableBlockVolume secondUnmodifiableVolume = second.getUnmodifiableBlockView();
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().switchToPhase(PluginPhase.State.BLOCK_WORKER, PhaseContext.start().add(NamedCause.source(this)).addCaptures().complete());
        }
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    BlockState block = merger.merge(firstUnmodifiableVolume, x, y, z, secondUnmodifiableVolume, x + xOffsetSecond, y + yOffsetSecond, z + zOffsetSecond);
                    destination.setBlock(x + xOffsetDestination, y + yOffsetDestination, z + zOffsetDestination, block, this.cause);
                }
            }
        }
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().completePhase(PluginPhase.State.BLOCK_WORKER);
        }
    }

    @Override
    public void iterate(BlockVolumeVisitor<V> visitor) {
        int xMin = this.volume.getBlockMin().getX();
        int yMin = this.volume.getBlockMin().getY();
        int zMin = this.volume.getBlockMin().getZ();
        int xMax = this.volume.getBlockMax().getX();
        int yMax = this.volume.getBlockMax().getY();
        int zMax = this.volume.getBlockMax().getZ();
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().switchToPhase(PluginPhase.State.BLOCK_WORKER, PhaseContext.start().add(NamedCause.source(this)).addCaptures().complete());
        }
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    visitor.visit(this.volume, x, y, z);
                }
            }
        }
        if (CauseTracker.ENABLED) {
            CauseTracker.getInstance().completePhase(PluginPhase.State.BLOCK_WORKER);
        }
    }

    @Override
    public <T> T reduce(BlockVolumeReducer<T> reducer, BiFunction<T, T, T> merge, T identity) {
        UnmodifiableBlockVolume unmodifiableVolume = this.volume.getUnmodifiableBlockView();
        int xMin = unmodifiableVolume.getBlockMin().getX();
        int yMin = unmodifiableVolume.getBlockMin().getY();
        int zMin = unmodifiableVolume.getBlockMin().getZ();
        int xMax = unmodifiableVolume.getBlockMax().getX();
        int yMax = unmodifiableVolume.getBlockMax().getY();
        int zMax = unmodifiableVolume.getBlockMax().getZ();
        T reduction = identity;
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    reduction = reducer.reduce(unmodifiableVolume, x, y, z, reduction);
                }
            }
        }
        return reduction;
    }

    private Vector3i align(BlockVolume other) {
        Vector3i thisSize = this.volume.getBlockSize();
        Vector3i otherSize = other.getBlockSize();
        Preconditions.checkArgument((otherSize.getX() >= thisSize.getX() && otherSize.getY() >= thisSize.getY() && otherSize.getZ() >= thisSize.getZ() ? 1 : 0) != 0, (Object)"Other volume is smaller than work volume");
        return other.getBlockMin().sub(this.volume.getBlockMin());
    }
}

