/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import net.minecraft.world.gen.feature.WorldGenDungeons;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.common.interfaces.world.gen.IWorldGenDungeons;

public class DungeonBuilder
implements Dungeon.Builder {
    private VariableAmount attempts;
    private MobSpawnerData data;
    private LootTable<ItemStackSnapshot> items;

    public DungeonBuilder() {
        this.reset();
    }

    @Override
    public Dungeon.Builder attempts(VariableAmount attempts) {
        this.attempts = attempts;
        return this;
    }

    @Override
    public Dungeon.Builder mobSpawnerData(MobSpawnerData data) {
        this.data = data;
        return this;
    }

    @Override
    public Dungeon.Builder minimumSpawnDelay(short delay) {
        this.data.set(Keys.SPAWNER_MINIMUM_DELAY, delay);
        return this;
    }

    @Override
    public Dungeon.Builder maximumSpawnDelay(short delay) {
        this.data.set(Keys.SPAWNER_MAXIMUM_DELAY, delay);
        return this;
    }

    @Override
    public Dungeon.Builder spawnCount(short count) {
        this.data.set(Keys.SPAWNER_SPAWN_COUNT, count);
        return this;
    }

    @Override
    public Dungeon.Builder maximumNearbyEntities(short count) {
        this.data.set(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, count);
        return this;
    }

    @Override
    public Dungeon.Builder requiredPlayerRange(short range) {
        this.data.set(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, range);
        return this;
    }

    @Override
    public Dungeon.Builder spawnRange(short range) {
        this.data.set(Keys.SPAWNER_SPAWN_RANGE, range);
        return this;
    }

    @Override
    public Dungeon.Builder possibleEntities(WeightedTable<EntitySnapshot> entities) {
        this.data.set(Keys.SPAWNER_ENTITIES, entities);
        return this;
    }

    @Override
    public Dungeon.Builder possibleItems(LootTable<ItemStackSnapshot> items) {
        this.items = items;
        return this;
    }

    @Override
    public Dungeon.Builder from(Dungeon value) {
        this.attempts(value.getAttemptsPerChunk());
        this.mobSpawnerData(value.getSpawnerData());
        this.items = new LootTable();
        this.items.addAll(value.getPossibleContents());
        return this;
    }

    @Override
    public Dungeon.Builder reset() {
        this.attempts = VariableAmount.fixed(8.0);
        this.items = new LootTable();
        return this;
    }

    @Override
    public Dungeon build() throws IllegalStateException {
        Dungeon populator = (Dungeon)new WorldGenDungeons();
        populator.setAttemptsPerChunk(this.attempts);
        ((IWorldGenDungeons)((Object)populator)).setSpawnerData(this.data);
        populator.getPossibleContents().clearPool();
        populator.getPossibleContents().addAll(this.items);
        return populator;
    }
}

