/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.WaterLily;

public class WaterLilyBuilder
implements WaterLily.Builder {
    private VariableAmount count;

    public WaterLilyBuilder() {
        this.reset();
    }

    @Override
    public WaterLily.Builder perChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public WaterLily.Builder from(WaterLily value) {
        this.count = value.getWaterLilyPerChunk();
        return this;
    }

    @Override
    public WaterLily.Builder reset() {
        this.count = VariableAmount.fixed(10.0);
        return this;
    }

    @Override
    public WaterLily build() throws IllegalStateException {
        WaterLily pop = (WaterLily)new WorldGenWaterlily();
        pop.setWaterLilyPerChunk(this.count);
        return pop;
    }
}

