/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;

public class EndBiomeGenerationPopulator
implements GenerationPopulator {
    private final Cause populatorCause = Cause.source(this).build();

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        Vector3i min = buffer.getBlockMin();
        Vector3i max = buffer.getBlockMax();
        BlockState iblockstate = BlockTypes.END_STONE.getDefaultState();
        for (int x = min.getX(); x <= max.getX(); ++x) {
            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                for (int y = max.getY(); y >= min.getY(); --y) {
                    BlockState iblockstate2 = buffer.getBlock(x, y, z);
                    if (iblockstate2.getType() != BlockTypes.STONE) continue;
                    buffer.setBlock(x, y, z, iblockstate, this.populatorCause);
                }
            }
        }
    }
}

