/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;

public class SwampLilyPopulator
implements GenerationPopulator {
    private NoiseGeneratorPerlin noise = new NoiseGeneratorPerlin(new Random(2345L), 1);
    private final Cause populatorCause = Cause.source(this).build();

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        Vector3i min = buffer.getBlockMin();
        Vector3i max = buffer.getBlockMax();
        for (int x = min.getX(); x < max.getX(); ++x) {
            block1: for (int z = min.getZ(); z < max.getZ(); ++z) {
                double d1 = this.noise.func_151601_a((double)x * 0.25, (double)z * 0.25);
                if (!(d1 > 0.0)) continue;
                for (int i1 = 255; i1 >= 0; --i1) {
                    if (buffer.getBlock(x, i1, z).getType() == BlockTypes.AIR) continue;
                    if (i1 != 62 || buffer.getBlock(x, i1, z).getType() == BlockTypes.WATER) continue block1;
                    buffer.setBlock(x, i1, z, BlockTypes.WATER.getDefaultState(), this.populatorCause);
                    if (!(d1 < 0.12)) continue block1;
                    buffer.setBlock(x, i1 + 1, z, BlockTypes.WATERLILY.getDefaultState(), this.populatorCause);
                    continue block1;
                }
            }
        }
    }
}

