/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.type;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.type.BiomeTreeType;

public class SpongeBiomeTreeType
implements BiomeTreeType {
    private String name;
    private PopulatorObject smallObject;
    @Nullable
    private PopulatorObject largeObject;

    public SpongeBiomeTreeType(String name, PopulatorObject small) {
        this.name = name;
        this.smallObject = small;
    }

    public SpongeBiomeTreeType(String name, PopulatorObject small, @Nullable PopulatorObject large) {
        this(name, small);
        this.largeObject = large;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PopulatorObject getPopulatorObject() {
        return this.smallObject;
    }

    @Override
    public void setPopulatorObject(PopulatorObject object) {
        this.smallObject = (PopulatorObject)Preconditions.checkNotNull((Object)object);
    }

    @Override
    public boolean hasLargeEquivalent() {
        return this.largeObject != null;
    }

    @Override
    public Optional<PopulatorObject> getLargePopulatorObject() {
        return Optional.ofNullable(this.largeObject);
    }

    @Override
    public void setLargePopulatorObject(@Nullable PopulatorObject object) {
        this.largeObject = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpongeBiomeTreeType)) {
            return false;
        }
        SpongeBiomeTreeType b = (SpongeBiomeTreeType)o;
        return this.getId().equals(b.getId());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        Objects.ToStringHelper tsh = Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("smallObj", (Object)this.smallObject.getClass().getName());
        if (this.largeObject != null) {
            tsh.add("largeObj", (Object)this.largeObject.getClass().getName());
        }
        return tsh.toString();
    }
}

