/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.interfaces.world.IMixinAnvilChunkLoader;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

public class WorldStorageUtil {
    public static CompletableFuture<Boolean> doesChunkExist(WorldServer world, IChunkLoader chunkLoader, Vector3i chunkCoords) {
        int x = chunkCoords.getX();
        int z = chunkCoords.getZ();
        if (!(chunkLoader instanceof IMixinAnvilChunkLoader) || !SpongeChunkLayout.instance.isValidChunk(x, chunkCoords.getY(), z)) {
            return CompletableFuture.completedFuture(false);
        }
        return SpongeScheduler.getInstance().submitAsyncTask(() -> ((IMixinAnvilChunkLoader)chunkLoader).chunkExists((World)world, x, z));
    }

    public static CompletableFuture<Optional<DataContainer>> getChunkData(WorldServer world, IChunkLoader chunkLoader, Vector3i chunkCoords) {
        int x = chunkCoords.getX();
        int y = chunkCoords.getY();
        int z = chunkCoords.getZ();
        if (!(chunkLoader instanceof IMixinAnvilChunkLoader) || !SpongeChunkLayout.instance.isValidChunk(x, y, z)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        File worldDir = ((IMixinAnvilChunkLoader)chunkLoader).getWorldDir().toFile();
        return SpongeScheduler.getInstance().submitAsyncTask(() -> {
            DataInputStream stream = RegionFileCache.func_76549_c((File)worldDir, (int)x, (int)z);
            return Optional.ofNullable(WorldStorageUtil.readDataFromRegion(stream));
        });
    }

    public static DataContainer readDataFromRegion(DataInputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        NBTTagCompound data = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        if (!data.func_150297_b("Level", 10)) {
            return null;
        }
        NBTTagCompound level = data.func_74775_l("Level");
        if (!level.func_150297_b("Sections", 9)) {
            return null;
        }
        return NbtTranslator.getInstance().translateFrom(level);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterable<Path> listRegionFiles(Path worldDir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(worldDir.resolve("region"), "*.mca");){
            ArrayList arrayList = Lists.newArrayList(stream);
            return arrayList;
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    public static RegionFile getRegionFile(Path regionFilePath) {
        File file = regionFilePath.toFile();
        RegionFile regionFile = (RegionFile)RegionFileCache.field_76553_a.get(file);
        if (regionFile != null) {
            return regionFile;
        }
        if (RegionFileCache.field_76553_a.size() >= 256) {
            RegionFileCache.func_76551_a();
        }
        regionFile = new RegionFile(file);
        RegionFileCache.field_76553_a.put(file, regionFile);
        return regionFile;
    }
}

