/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class PluginMetadata {
    private String id;
    @Nullable
    private String name;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @Nullable
    private String url;
    @Nullable
    private String minecraftVersion;
    private final List<String> authors = new ArrayList<String>();
    private final Set<Dependency> dependencies = new HashSet<Dependency>();
    private final Set<Dependency> loadBefore = new HashSet<Dependency>();
    private final Set<Dependency> loadAfter = new HashSet<Dependency>();
    private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public PluginMetadata(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id cannot be empty");
        this.id = id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = Strings.emptyToNull((String)name);
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = Strings.emptyToNull((String)version);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = Strings.emptyToNull((String)description);
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = Strings.emptyToNull((String)url);
    }

    @Nullable
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public void setMinecraftVersion(@Nullable String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void addAuthor(String author) {
        Preconditions.checkNotNull((Object)author, (Object)"author");
        if (author.isEmpty()) {
            return;
        }
        this.authors.add(author);
    }

    public Set<Dependency> getRequiredDependencies() {
        return this.dependencies;
    }

    public Set<Dependency> getLoadBefore() {
        return this.loadBefore;
    }

    public Set<Dependency> getLoadAfter() {
        return this.loadAfter;
    }

    public void addRequiredDependency(Dependency dependency) {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency");
        this.dependencies.add(dependency);
    }

    public void loadBefore(Dependency dependency) {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency");
        this.loadBefore.add(dependency);
    }

    public void loadBefore(Dependency dependency, boolean required) {
        this.loadBefore(dependency);
        if (required) {
            this.addRequiredDependency(dependency);
        }
    }

    public void loadAfter(Dependency dependency) {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency");
        this.loadAfter.add(dependency);
    }

    public void loadAfter(Dependency dependency, boolean required) {
        this.loadAfter(dependency);
        if (required) {
            this.addRequiredDependency(dependency);
        }
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Nullable
    public <T> T getExtension(String key) {
        return (T)this.extensions.get(key);
    }

    public void setExtension(String key, Object extension) {
        this.extensions.put(key, extension);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("version", (Object)this.version).add("description", (Object)this.description).add("url", (Object)this.url).add("minecraftVersion", (Object)this.minecraftVersion).add("authors", this.authors).add("dependencies", this.dependencies).add("loadBefore", this.loadBefore).add("loadAfter", this.loadAfter).add("extensions", this.extensions).toString();
    }

    public static final class Dependency {
        private final String id;
        @Nullable
        private final String version;

        public Dependency(String id, String version) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"id cannot be empty");
            this.version = Strings.emptyToNull((String)version);
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.id.equals(that.id) && Objects.equal((Object)this.version, (Object)that.version);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.version});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("version", (Object)this.version).toString();
        }
    }
}

