/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.init.Bootstrap;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.datafix.DataFixesManager;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.entity.ai.SpongeEntityAICommonSuperclass;
import org.spongepowered.common.interfaces.IMixinServerCommandManager;
import org.spongepowered.common.network.message.SpongeMessageHandler;
import org.spongepowered.common.plugin.AbstractPluginContainer;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.service.permission.SpongeContextCalculator;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.sql.SqlServiceImpl;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;
import org.spongepowered.server.guice.VanillaGuiceModule;
import org.spongepowered.server.launch.VanillaCommandLine;
import org.spongepowered.server.plugin.VanillaPluginManager;

public final class SpongeVanilla
extends AbstractPluginContainer {
    public static final SpongeVanilla INSTANCE = new SpongeVanilla();
    @Nullable
    private static MinecraftServer server;
    private final SpongeGame game;
    private Cause gameCause;

    private SpongeVanilla() {
        NetHandlerPlayServer.class.getName();
        Guice.createInjector(new VanillaGuiceModule(this, LogManager.getLogger((String)"Sponge"))).getInstance(SpongeImpl.class);
        this.game = SpongeImpl.getGame();
        RegistryHelper.setFinalStatic(Sponge.class, "game", this.game);
        this.gameCause = Cause.source(this.game).build();
    }

    public static boolean isServerAvailable() {
        return server != null;
    }

    public static MinecraftServer getServer() {
        Preconditions.checkState((server != null ? 1 : 0) != 0, (Object)"Attempting to get server while it is unavailable!");
        return server;
    }

    public static void main(String[] args) {
        Preconditions.checkState((server == null ? 1 : 0) != 0, (Object)"Server was already initialized");
        OptionSet options = VanillaCommandLine.parse(args);
        try {
            Bootstrap.func_151354_b();
            File worldDir = options.has(VanillaCommandLine.WORLD_DIR) ? options.valueOf(VanillaCommandLine.WORLD_DIR) : new File(".");
            YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService sessionService = authenticationService.createMinecraftSessionService();
            GameProfileRepository profileRepository = authenticationService.createProfileRepository();
            PlayerProfileCache profileCache = new PlayerProfileCache(profileRepository, new File(worldDir, MinecraftServer.field_152367_a.getName()));
            server = new DedicatedServer(worldDir, DataFixesManager.func_188279_a(), authenticationService, sessionService, profileRepository, profileCache);
            if (options.has(VanillaCommandLine.WORLD_NAME)) {
                server.func_71261_m(options.valueOf(VanillaCommandLine.WORLD_NAME));
            }
            if (options.has(VanillaCommandLine.PORT)) {
                server.func_71208_b(options.valueOf(VanillaCommandLine.PORT).intValue());
            }
            if (options.has(VanillaCommandLine.BONUS_CHEST)) {
                server.func_71194_c(true);
            }
            server.func_71256_s();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((MinecraftServer)server).func_71260_j()));
        }
        catch (Exception e) {
            SpongeImpl.getLogger().fatal("Failed to start the Minecraft server", (Throwable)e);
            System.exit(1);
        }
    }

    public void preInitialize() throws Exception {
        SpongeImpl.getLogger().info("Loading Sponge...");
        this.game.getRegistry().preRegistryInit();
        this.game.getEventManager().registerListeners(this, SpongeInternalListeners.getInstance());
        SpongeBootstrap.initializeServices();
        SpongeBootstrap.initializeCommands();
        SpongeImpl.getLogger().info("Loading plugins...");
        ((VanillaPluginManager)this.game.getPluginManager()).loadPlugins();
        SpongeImpl.postState(GameState.CONSTRUCTION, SpongeEventFactory.createGameConstructionEvent(this.gameCause));
        SpongeImpl.getLogger().info("Initializing plugins...");
        SpongeImpl.postState(GameState.PRE_INITIALIZATION, SpongeEventFactory.createGamePreInitializationEvent(this.gameCause));
        this.game.getRegistry().preInit();
        Preconditions.checkState((boolean)Class.forName("org.spongepowered.api.entity.ai.task.AbstractAITask").getSuperclass().equals(SpongeEntityAICommonSuperclass.class));
        SpongeInternalListeners.getInstance().registerServiceCallback(PermissionService.class, input -> input.registerContextCalculator(new SpongeContextCalculator()));
        SpongeHooks.enableThreadContentionMonitoring();
        SpongeMessageHandler.init();
    }

    public void initialize() {
        SpongeImpl.getRegistry().init();
        if (!this.game.getServiceManager().provide(PermissionService.class).isPresent()) {
            SpongePermissionService service = new SpongePermissionService(this.game);
            service.getGroupForOpLevel(1).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.selector", Tristate.TRUE);
            service.getGroupForOpLevel(2).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.commandblock", Tristate.TRUE);
            this.game.getServiceManager().setProvider(this, PermissionService.class, service);
        }
        SpongeImpl.postState(GameState.INITIALIZATION, SpongeEventFactory.createGameInitializationEvent(this.gameCause));
        SpongeImpl.getRegistry().postInit();
        SpongeImpl.postState(GameState.POST_INITIALIZATION, SpongeEventFactory.createGamePostInitializationEvent(this.gameCause));
        SpongeImpl.getLogger().info("Successfully loaded and initialized plugins.");
        SpongeImpl.postState(GameState.LOAD_COMPLETE, SpongeEventFactory.createGameLoadCompleteEvent(this.gameCause));
    }

    public void onServerAboutToStart() {
        ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerEarlyCommands(this.game);
        SpongeImpl.postState(GameState.SERVER_ABOUT_TO_START, SpongeEventFactory.createGameAboutToStartServerEvent(this.gameCause));
    }

    public void onServerStarting() {
        SpongeImpl.postState(GameState.SERVER_STARTING, SpongeEventFactory.createGameStartingServerEvent(this.gameCause));
        SpongeImpl.postState(GameState.SERVER_STARTED, SpongeEventFactory.createGameStartedServerEvent(this.gameCause));
        ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerLowPriorityCommands(this.game);
        SpongePlayerDataHandler.init();
    }

    public void onServerStopping() {
        SpongeImpl.postState(GameState.SERVER_STOPPING, SpongeEventFactory.createGameStoppingServerEvent(this.gameCause));
    }

    public void onServerStopped() throws IOException {
        SpongeImpl.postState(GameState.SERVER_STOPPED, SpongeEventFactory.createGameStoppedServerEvent(this.gameCause));
        ((SqlServiceImpl)this.game.getServiceManager().provideUnchecked(SqlService.class)).close();
    }

    @Override
    public String getId() {
        return "sponge";
    }

    @Override
    public String getName() {
        return SpongeImpl.IMPLEMENTATION_NAME.orElse("SpongeVanilla");
    }

    @Override
    public Optional<String> getVersion() {
        return SpongeImpl.IMPLEMENTATION_VERSION;
    }

    @Override
    public Optional<String> getMinecraftVersion() {
        return Optional.of(SpongeImpl.MINECRAFT_VERSION.getName());
    }

    @Override
    public Logger getLogger() {
        return SpongeImpl.getSlf4jLogger();
    }

    public Optional<Object> getInstance() {
        return Optional.of(this);
    }
}

