/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.console;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import jline.console.completer.Completer;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.common.SpongeImpl;

public final class ConsoleCommandCompleter
implements Completer {
    private final DedicatedServer server;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = (DedicatedServer)Preconditions.checkNotNull((Object)server, (Object)"server");
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        boolean prefix;
        int len = buffer.length();
        if (buffer.isEmpty() || buffer.charAt(0) != '/') {
            buffer = '/' + buffer;
            prefix = false;
        } else {
            prefix = true;
        }
        String input = buffer;
        ListenableFuture tabComplete = this.server.func_175586_a(() -> this.server.func_184104_a((ICommandSender)this.server, input, this.server.func_180425_c(), false));
        try {
            List completions = (List)tabComplete.get();
            Collections.sort(completions);
            if (prefix) {
                candidates.addAll(completions);
            } else {
                for (String completion : completions) {
                    candidates.add(completion.charAt(0) == '/' ? completion.substring(1) : completion);
                }
            }
            int pos = buffer.lastIndexOf(32);
            if (pos == -1) {
                return cursor - len;
            }
            if (prefix) {
                return cursor - len + pos + 1;
            }
            return cursor - len + pos;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            SpongeImpl.getLogger().error("Failed to tab complete", (Throwable)e);
        }
        return cursor;
    }
}

