/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.console;

import net.minecraft.util.text.TextFormatting;
import org.fusesource.jansi.Ansi;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.server.launch.console.TerminalConsoleAppender;

public final class ConsoleFormatter {
    private static final String RESET = TerminalConsoleAppender.ANSI_RESET;
    private static final String[] ansi = new String[LegacyTexts.getFormattingCount()];

    private ConsoleFormatter() {
    }

    private static void map(TextFormatting formatting, String ansiMapping) {
        ConsoleFormatter.ansi[formatting.ordinal()] = ansiMapping;
    }

    public static String format(String text) {
        int next = text.indexOf(167);
        int last = text.length() - 1;
        if (next == -1 || next == last) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() + 20);
        int pos = 0;
        do {
            if (pos != next) {
                result.append(text, pos, next);
            }
            pos = next;
            int format = LegacyTexts.findFormat(text.charAt(next + 1));
            if (format != -1) {
                result.append(ansi[format]);
                pos = next += 2;
                continue;
            }
            ++next;
        } while ((next = text.indexOf(167, next)) != -1 && next < last);
        return result.append(text, pos, text.length()).append(RESET).toString();
    }

    static {
        ConsoleFormatter.map(TextFormatting.BLACK, Ansi.ansi().reset().fg(Ansi.Color.BLACK).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_BLUE, Ansi.ansi().reset().fg(Ansi.Color.BLUE).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_GREEN, Ansi.ansi().reset().fg(Ansi.Color.GREEN).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_AQUA, Ansi.ansi().reset().fg(Ansi.Color.CYAN).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_RED, Ansi.ansi().reset().fg(Ansi.Color.RED).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_PURPLE, Ansi.ansi().reset().fg(Ansi.Color.MAGENTA).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.GOLD, Ansi.ansi().reset().fg(Ansi.Color.YELLOW).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.GRAY, Ansi.ansi().reset().fg(Ansi.Color.WHITE).boldOff().toString());
        ConsoleFormatter.map(TextFormatting.DARK_GRAY, Ansi.ansi().reset().fg(Ansi.Color.BLACK).bold().toString());
        ConsoleFormatter.map(TextFormatting.BLUE, Ansi.ansi().reset().fg(Ansi.Color.BLUE).bold().toString());
        ConsoleFormatter.map(TextFormatting.GREEN, Ansi.ansi().reset().fg(Ansi.Color.GREEN).bold().toString());
        ConsoleFormatter.map(TextFormatting.AQUA, Ansi.ansi().reset().fg(Ansi.Color.CYAN).bold().toString());
        ConsoleFormatter.map(TextFormatting.RED, Ansi.ansi().reset().fg(Ansi.Color.RED).bold().toString());
        ConsoleFormatter.map(TextFormatting.LIGHT_PURPLE, Ansi.ansi().reset().fg(Ansi.Color.MAGENTA).bold().toString());
        ConsoleFormatter.map(TextFormatting.YELLOW, Ansi.ansi().reset().fg(Ansi.Color.YELLOW).bold().toString());
        ConsoleFormatter.map(TextFormatting.WHITE, Ansi.ansi().reset().fg(Ansi.Color.WHITE).bold().toString());
        ConsoleFormatter.map(TextFormatting.OBFUSCATED, Ansi.ansi().a(Ansi.Attribute.BLINK_SLOW).toString());
        ConsoleFormatter.map(TextFormatting.BOLD, Ansi.ansi().a(Ansi.Attribute.UNDERLINE_DOUBLE).toString());
        ConsoleFormatter.map(TextFormatting.STRIKETHROUGH, Ansi.ansi().a(Ansi.Attribute.STRIKETHROUGH_ON).toString());
        ConsoleFormatter.map(TextFormatting.UNDERLINE, Ansi.ansi().a(Ansi.Attribute.UNDERLINE).toString());
        ConsoleFormatter.map(TextFormatting.ITALIC, Ansi.ansi().a(Ansi.Attribute.ITALIC).toString());
        ConsoleFormatter.map(TextFormatting.RESET, RESET);
    }
}

