/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.nio.file.Path;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.service.ServiceManager;
import org.spongepowered.api.service.SimpleServiceManager;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.asset.SpongeAssetManager;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.guice.ConfigDirAnnotation;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.world.SpongeTeleportHelper;
import org.spongepowered.server.SpongeVanilla;
import org.spongepowered.server.VanillaGame;
import org.spongepowered.server.VanillaPlatform;
import org.spongepowered.server.network.VanillaChannelRegistrar;
import org.spongepowered.server.plugin.MinecraftPluginContainer;
import org.spongepowered.server.plugin.SpongeApiContainer;
import org.spongepowered.server.plugin.VanillaPluginManager;

public class VanillaGuiceModule
extends AbstractModule {
    private final SpongeVanilla instance;
    private final Logger logger;

    public VanillaGuiceModule(SpongeVanilla instance, Logger logger) {
        this.instance = instance;
        this.logger = logger;
    }

    @Override
    protected void configure() {
        this.bind(SpongeVanilla.class).toInstance(this.instance);
        this.bind(Logger.class).toInstance(this.logger);
        this.bind(PluginContainer.class).annotatedWith(Names.named("sponge")).toInstance(this.instance);
        this.bind(PluginContainer.class).annotatedWith(Names.named("spongeapi")).to(SpongeApiContainer.class).in(Scopes.SINGLETON);
        this.bind(PluginContainer.class).annotatedWith(Names.named("minecraft")).to(MinecraftPluginContainer.class).in(Scopes.SINGLETON);
        this.bind(Game.class).to(VanillaGame.class).in(Scopes.SINGLETON);
        this.bind(MinecraftVersion.class).toInstance(SpongeImpl.MINECRAFT_VERSION);
        this.bind(Platform.class).to(VanillaPlatform.class).in(Scopes.SINGLETON);
        this.bind(PluginManager.class).to(VanillaPluginManager.class).in(Scopes.SINGLETON);
        this.bind(EventManager.class).to(SpongeEventManager.class).in(Scopes.SINGLETON);
        this.bind(AssetManager.class).to(SpongeAssetManager.class).in(Scopes.SINGLETON);
        this.bind(GameRegistry.class).to(SpongeGameRegistry.class).in(Scopes.SINGLETON);
        this.bind(ServiceManager.class).to(SimpleServiceManager.class).in(Scopes.SINGLETON);
        this.bind(TeleportHelper.class).to(SpongeTeleportHelper.class).in(Scopes.SINGLETON);
        this.bind(ChannelRegistrar.class).to(VanillaChannelRegistrar.class).in(Scopes.SINGLETON);
        ConfigDirAnnotation sharedRoot = new ConfigDirAnnotation(true);
        this.bind(Path.class).annotatedWith(sharedRoot).toInstance(SpongeImpl.getPluginConfigDir());
        this.bind(File.class).annotatedWith(sharedRoot).toInstance(SpongeImpl.getPluginConfigDir().toFile());
    }
}

