/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import joptsimple.OptionSet;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.common.launch.SpongeLaunch;
import org.spongepowered.server.launch.LaunchException;
import org.spongepowered.server.launch.VanillaCommandLine;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.console.TerminalConsoleAppender;
import org.spongepowered.server.launch.plugin.VanillaLaunchPluginManager;
import org.spongepowered.server.launch.transformer.at.AccessTransformers;
import org.spongepowered.server.launch.transformer.deobf.SrgRemapper;

public final class VanillaServerTweaker
implements ITweaker {
    private static final String FORGE_GRADLE_CSV_DIR = "net.minecraftforge.gradle.GradleStart.csvDir";
    private static boolean isDeobfuscated;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        if (gameDir == null) {
            gameDir = new File("");
        }
        SpongeLaunch.initPaths(gameDir);
        VanillaCommandLine.parse(args);
        TerminalConsoleAppender.initialize();
        List<String> unrecognizedOptions = VanillaCommandLine.getUnrecognizedOptions();
        if (!unrecognizedOptions.isEmpty()) {
            VanillaLaunch.getLogger().warn("Found unrecognized command line option(s): {}", new Object[]{unrecognizedOptions});
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader loader) {
        VanillaLaunch.getLogger().info("Initializing Sponge...");
        OptionSet options = VanillaCommandLine.getOptions().get();
        VanillaServerTweaker.configureLaunchClassLoader(loader);
        VanillaServerTweaker.configureDeobfuscation(loader);
        VanillaServerTweaker.registerAccessTransformers(options);
        VanillaServerTweaker.configureMixinEnvironment();
        VanillaServerTweaker.searchPlugins(options);
        VanillaServerTweaker.registerTransformers(loader);
        VanillaLaunch.getLogger().info("Initialization finished. Starting Minecraft server...");
    }

    private static void configureDeobfuscation(LaunchClassLoader loader) {
        VanillaLaunch.getLogger().debug("Applying runtime de-obfuscation...");
        if (VanillaServerTweaker.detectObfuscation()) {
            VanillaLaunch.getLogger().info("De-obfuscation mappings are provided by MCP (http://www.modcoderpack.com)");
            Launch.blackboard.put("vanilla.srg_mappings", Resources.getResource((String)"mappings.srg"));
            loader.registerTransformer("org.spongepowered.server.launch.transformer.deobf.NotchDeobfuscationTransformer");
        } else {
            isDeobfuscated = true;
            String mcpDir = System.getProperty(FORGE_GRADLE_CSV_DIR);
            if (mcpDir != null) {
                Launch.blackboard.put("vanilla.mcp_mappings", Paths.get(mcpDir, new String[0]));
                loader.registerTransformer("org.spongepowered.server.launch.transformer.deobf.SeargeDeobfuscationTransformer");
            }
        }
    }

    private static void registerAccessTransformers(OptionSet options) {
        VanillaLaunch.getLogger().debug("Registering access transformers...");
        try {
            AccessTransformers.register(Resources.getResource((String)"META-INF/common_at.cfg"));
            AccessTransformers.register(Resources.getResource((String)"META-INF/vanilla_at.cfg"));
        }
        catch (IOException e) {
            throw new LaunchException("Failed to register SpongeCommon/SpongeVanilla access transformers", e);
        }
        for (String at : options.valuesOf(VanillaCommandLine.ACCESS_TRANSFORMER)) {
            try {
                Path path = Paths.get(at, new String[0]);
                if (Files.isReadable(path)) {
                    AccessTransformers.register(path);
                    continue;
                }
                AccessTransformers.register(Resources.getResource((String)at));
            }
            catch (IOException e) {
                VanillaLaunch.getLogger().error("Failed to load access transformer from {}", new Object[]{at, e});
            }
        }
    }

    private static void configureMixinEnvironment() {
        VanillaLaunch.getLogger().debug("Initializing Mixin environment...");
        SpongeLaunch.setupMixinEnvironment();
        Mixins.addConfiguration("mixins.vanilla.core.json");
        Mixins.addConfiguration("mixins.vanilla.entityactivation.json");
        Mixins.addConfiguration("mixins.vanilla.chunkio.json");
        MixinEnvironment.getDefaultEnvironment().setSide(MixinEnvironment.Side.SERVER);
        SrgRemapper remapper = VanillaLaunch.getRemapper();
        if (remapper != null) {
            MixinEnvironment.getDefaultEnvironment().getRemappers().add(remapper);
        }
    }

    private static void searchPlugins(OptionSet options) {
        VanillaLaunch.getLogger().debug("Searching for plugins...");
        try {
            VanillaLaunchPluginManager.findPlugins(isDeobfuscated || options.has(VanillaCommandLine.SCAN_CLASSPATH), options.has(VanillaCommandLine.SCAN_FULL_CLASSPATH));
        }
        catch (IOException e) {
            throw new LaunchException("Failed to search for plugins", e);
        }
    }

    private static void registerTransformers(LaunchClassLoader loader) {
        loader.registerTransformer("org.spongepowered.server.launch.transformer.at.AccessTransformer");
        loader.registerTransformer("org.spongepowered.common.launch.transformer.SpongeSuperclassTransformer");
        SpongeLaunch.setupSuperClassTransformer();
    }

    public String getLaunchTarget() {
        return "org.spongepowered.server.SpongeVanilla";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    public static boolean isDeobfuscated() {
        return isDeobfuscated;
    }

    private static boolean detectObfuscation() {
        try {
            return Launch.classLoader.getClassBytes("net.minecraft.server.dedicated.DedicatedServer") == null;
        }
        catch (IOException ignored) {
            return true;
        }
    }

    private static void configureLaunchClassLoader(LaunchClassLoader loader) {
        loader.addClassLoaderExclusion("org.slf4j.");
        loader.addClassLoaderExclusion("jline.");
        loader.addClassLoaderExclusion("org.fusesource.");
        loader.addClassLoaderExclusion("com.mojang.util.QueueLogAppender");
        loader.addClassLoaderExclusion("joptsimple.");
        loader.addClassLoaderExclusion("com.google.common.");
        loader.addClassLoaderExclusion("org.spongepowered.common.launch.");
        loader.addClassLoaderExclusion("org.spongepowered.server.launch.");
        loader.addClassLoaderExclusion("org.spongepowered.plugin.");
        loader.addClassLoaderExclusion("org.spongepowered.api.plugin.");
        loader.addTransformerExclusion("com.google.");
        loader.addTransformerExclusion("org.apache.");
        loader.addTransformerExclusion("io.netty.");
        loader.addTransformerExclusion("com.flowpowered.");
        loader.addTransformerExclusion("it.unimi.dsi.fastutil.");
        loader.addTransformerExclusion("com.github.benmanes.caffeine.");
        loader.addTransformerExclusion("org.aopalliance.");
        loader.addTransformerExclusion("ninja.leaping.configurate.");
        loader.addTransformerExclusion("com.typesafe.config.");
        loader.addTransformerExclusion("org.yaml.snakeyaml.");
        loader.addTransformerExclusion("com.zaxxer.hikari.");
        loader.addTransformerExclusion("org.h2.");
        loader.addTransformerExclusion("org.mariadb.");
        loader.addTransformerExclusion("org.sqlite.");
    }
}

