/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.console;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.function.Function;
import javax.annotation.Nullable;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import joptsimple.OptionSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.spongepowered.server.launch.VanillaCommandLine;
import org.spongepowered.server.launch.console.LoggingPrintStream;

@Plugin(name="TerminalConsole", category="Core", elementType="appender", printObject=true)
public class TerminalConsoleAppender
extends AbstractAppender {
    public static final String ANSI_RESET = Ansi.ansi().fgDefault().reset().toString();
    private static final String ANSI_ERROR = Ansi.ansi().fgRed().bold().toString();
    private static final String ANSI_WARN = Ansi.ansi().fgYellow().bold().toString();
    private static final boolean ENABLE_JLINE = PropertiesUtil.getProperties().getBooleanProperty("jline.enable", true);
    private static final PrintStream out = System.out;
    private static boolean initialized;
    @Nullable
    private static ConsoleReader reader;
    private static Function<String, String> formatter;

    @Nullable
    public static ConsoleReader getReader() {
        return reader;
    }

    public static void setFormatter(@Nullable Function<String, String> format) {
        formatter = format != null ? format : Function.identity();
    }

    protected TerminalConsoleAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static TerminalConsoleAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") @Nullable Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") String ignore) {
        if (name == null) {
            LOGGER.error("No name provided for TerminalConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null, null);
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        System.setProperty("log4j.skipJansi", "true");
        return new TerminalConsoleAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    public void start() {
        super.start();
        if (VanillaCommandLine.getOptions().isPresent()) {
            TerminalConsoleAppender.initialize();
        }
    }

    public static void initialize() {
        System.setProperty("jline.expandevents", "false");
        if (!initialized) {
            initialized = true;
            OptionSet options = VanillaCommandLine.getOptions().get();
            if (ENABLE_JLINE && !options.has(VanillaCommandLine.NO_JLINE)) {
                boolean hasConsole;
                boolean bl = hasConsole = System.console() != null;
                if (hasConsole) {
                    try {
                        AnsiConsole.systemInstall();
                        reader = new ConsoleReader();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to initialize terminal. Falling back to default.", (Throwable)e);
                    }
                }
                if (reader == null) {
                    if (hasConsole || options.has(VanillaCommandLine.FORCE_JLINE) || System.getProperty("java.class.path").contains("idea_rt.jar")) {
                        TerminalFactory.configure("off");
                        TerminalFactory.reset();
                        try {
                            reader = new ConsoleReader();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to initialize fallback terminal. Falling back to standard output console.", (Throwable)e);
                        }
                    } else {
                        LOGGER.warn("Disabling terminal, you're running in an unsupported environment.");
                    }
                }
            }
            if (!options.has(VanillaCommandLine.NO_REDIRECT_STDOUT)) {
                System.setOut(new LoggingPrintStream(System.out, LogManager.getLogger((String)"STDOUT"), Level.INFO));
                System.setErr(new LoggingPrintStream(System.err, LogManager.getLogger((String)"STDERR"), Level.ERROR));
            }
        }
    }

    public void append(LogEvent event) {
        if (!initialized) {
            out.print(this.getLayout().toSerializable(event));
            return;
        }
        if (reader != null) {
            try {
                Writer out = reader.getOutput();
                out.write(13);
                out.write(this.formatEvent(event));
                reader.drawLine();
                reader.flush();
            }
            catch (IOException iOException) {}
        } else {
            out.print(this.formatEvent(event));
        }
    }

    protected String formatEvent(LogEvent event) {
        String formatted = formatter.apply(this.getLayout().toSerializable(event).toString());
        if (reader != null) {
            int level = event.getLevel().intLevel();
            if (level <= Level.ERROR.intLevel()) {
                return ANSI_ERROR + formatted + ANSI_RESET;
            }
            if (level <= Level.WARN.intLevel()) {
                return ANSI_WARN + formatted + ANSI_RESET;
            }
        }
        return formatted;
    }

    static {
        formatter = Function.identity();
    }
}

