/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;

public final class PluginSource {
    public static final PluginSource CLASSPATH = new PluginSource();
    private final Optional<Path> source;
    private boolean onClasspath;

    private PluginSource() {
        this.source = Optional.empty();
        this.onClasspath = true;
    }

    PluginSource(Path path) {
        this.source = Optional.of(path);
    }

    public Optional<Path> getPath() {
        return this.source;
    }

    public void addToClasspath() {
        if (this.onClasspath) {
            return;
        }
        this.onClasspath = true;
        try {
            Launch.classLoader.addURL(this.source.get().toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to add plugin " + this + " to classpath", e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSource other = (PluginSource)o;
        return this.source.equals(other.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        if (this.source.isPresent()) {
            return this.source.get().toString();
        }
        return "unknown";
    }
}

