/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.server.launch.VanillaLaunch;

final class PluginTweakers {
    private static final Splitter CONFIG_SPLITTER = Splitter.on((char)',');
    private static final Splitter PHASE_SPLITTER = Splitter.on((char)'@').limit(2);
    private static final String MIXIN_TWEAKER = "org.spongepowered.asm.launch.MixinTweaker";

    private PluginTweakers() {
    }

    static Set<String> findMixinConfigs(Path path, Attributes attributes) {
        String tweakClass = attributes.getValue("TweakClass");
        String configs = attributes.getValue("MixinConfigs");
        if (Strings.isNullOrEmpty((String)tweakClass)) {
            if (!Strings.isNullOrEmpty((String)configs)) {
                VanillaLaunch.getLogger().warn("Plugin {} defines mixin configs in its manifest but the tweak class is not set. Please add 'TweakClass' to your manifest and set it to 'org.spongepowered.asm.launch.MixinTweaker'.", new Object[]{path});
            }
            return null;
        }
        if (!tweakClass.equals(MIXIN_TWEAKER)) {
            VanillaLaunch.getLogger().warn("Skipping unsupported tweak class '{}' from plugin {}", new Object[]{tweakClass, path});
            return null;
        }
        if (Strings.isNullOrEmpty((String)configs)) {
            return null;
        }
        return Sets.newHashSet((Iterable)CONFIG_SPLITTER.split((CharSequence)configs));
    }

    static Set<String> findTokenProviders(Attributes attributes) {
        String tokenProviders = attributes.getValue("MixinTokenProviders");
        if (Strings.isNullOrEmpty((String)tokenProviders)) {
            return null;
        }
        return Sets.newHashSet((Iterable)CONFIG_SPLITTER.split((CharSequence)tokenProviders));
    }

    static void registerConfig(String config) {
        Mixins.addConfiguration(config);
    }

    static void registerTokenProvider(String provider) {
        if (provider.indexOf(64) != -1) {
            List parts = PHASE_SPLITTER.splitToList((CharSequence)provider);
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName((String)parts.get(1));
            if (phase != null) {
                MixinEnvironment.getEnvironment(phase).registerTokenProviderClass((String)parts.get(0));
            }
        } else {
            MixinEnvironment.getDefaultEnvironment().registerTokenProviderClass(provider);
        }
    }
}

