/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin.asm;

import com.google.common.base.Preconditions;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.launch.plugin.asm.WarningAnnotationVisitor;

final class DependencyAnnotationVisitor
extends WarningAnnotationVisitor {
    private final PluginMetadata metadata;
    private String id;
    private String version;
    private boolean optional;

    DependencyAnnotationVisitor(String className, PluginMetadata metadata) {
        super(327680, className);
        this.metadata = metadata;
    }

    @Override
    String getAnnotation() {
        return "@Dependency";
    }

    @Override
    public void visit(String name, Object value) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        switch (name) {
            case "id": {
                this.id = (String)value;
                return;
            }
            case "version": {
                this.version = (String)value;
                return;
            }
            case "optional": {
                this.optional = (Boolean)value;
                return;
            }
        }
        super.visit(name, value);
    }

    @Override
    public void visitEnd() {
        this.metadata.loadAfter(new PluginMetadata.Dependency(this.id, this.version), !this.optional);
    }
}

