/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin.asm;

import org.apache.logging.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.spongepowered.server.launch.VanillaLaunch;

abstract class WarningAnnotationVisitor
extends AnnotationVisitor {
    private static final Logger logger = VanillaLaunch.getLogger();
    final String className;

    protected WarningAnnotationVisitor(int api, String className) {
        super(api);
        this.className = className;
    }

    abstract String getAnnotation();

    @Override
    public void visit(String name, Object value) {
        logger.warn("Found unknown {} annotation element in {}: {} = {}", new Object[]{this.getAnnotation(), this.className, name, value});
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        logger.warn("Found unknown {} annotation element in {}: {} ({}) = {}", new Object[]{this.getAnnotation(), this.className, name, desc, value});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        logger.warn("Found unknown {} annotation element in {}: {} ({})", new Object[]{this.getAnnotation(), this.className, name, desc});
        return null;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        logger.warn("Found unknown {} annotation element in {}: {}", new Object[]{this.getAnnotation(), this.className, name});
        return null;
    }
}

