/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.deobf;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.spongepowered.server.launch.transformer.deobf.DeobfuscationTransformer;
import org.spongepowered.server.launch.transformer.deobf.reader.SrgReader;

public final class NotchDeobfuscationTransformer
extends DeobfuscationTransformer
implements IClassNameTransformer {
    private final ImmutableBiMap<String, String> classes;
    private final ImmutableTable<String, String, String> rawFields;
    private final ImmutableTable<String, String, String> rawMethods;
    private final Map<String, Map<String, String>> fields;
    private final Map<String, Map<String, String>> methods;
    private final Set<String> loadedClasses = new HashSet<String>();

    public NotchDeobfuscationTransformer() throws IOException {
        URL mappings = (URL)Launch.blackboard.get("vanilla.srg_mappings");
        SrgReader reader = new SrgReader();
        reader.read(mappings);
        this.classes = reader.getClasses();
        this.rawFields = reader.getFields();
        this.rawMethods = reader.getMethods();
        this.fields = Maps.newHashMapWithExpectedSize((int)this.rawFields.size());
        this.methods = Maps.newHashMapWithExpectedSize((int)this.rawMethods.size());
    }

    @Override
    public String map(String className) {
        String name = (String)this.classes.get((Object)className);
        if (name != null) {
            return name;
        }
        int innerClassPos = className.lastIndexOf(36);
        if (innerClassPos >= 0) {
            return this.map(className.substring(0, innerClassPos)).concat(className.substring(innerClassPos));
        }
        return className;
    }

    @Override
    public String unmap(String className) {
        String name = (String)this.classes.inverse().get((Object)className);
        if (name != null) {
            return name;
        }
        int innerClassPos = className.lastIndexOf(36);
        if (innerClassPos >= 0) {
            return this.unmap(className.substring(0, innerClassPos)).concat(className.substring(innerClassPos));
        }
        return className;
    }

    @Override
    public String mapFieldName(String owner, String fieldName, String desc) {
        String name;
        Map<String, String> fields = this.getFieldMap(owner);
        if (fields != null && (name = fields.get(fieldName + ':' + desc)) != null) {
            return name;
        }
        return fieldName;
    }

    @Nullable
    private Map<String, String> getFieldMap(String owner) {
        Map<String, String> result = this.fields.get(owner);
        if (result != null) {
            return result;
        }
        this.loadSuperMaps(owner);
        return this.fields.get(owner);
    }

    @Override
    public String mapMethodName(String owner, String methodName, String desc) {
        String name;
        Map<String, String> methods = this.getMethodMap(owner);
        if (methods != null && (name = methods.get(methodName.concat(desc))) != null) {
            return name;
        }
        return methodName;
    }

    @Nullable
    private Map<String, String> getMethodMap(String owner) {
        Map<String, String> result = this.methods.get(owner);
        if (result != null) {
            return result;
        }
        this.loadSuperMaps(owner);
        return this.methods.get(owner);
    }

    @Override
    public String mapSrgMethodIdentifier(String identifier) {
        return identifier;
    }

    public String remapClassName(String className) {
        return this.map(className.replace('.', '/')).replace('/', '.');
    }

    public String unmapClassName(String className) {
        return this.unmap(className.replace('.', '/')).replace('/', '.');
    }

    private void loadSuperMaps(String name) {
        byte[] bytes;
        if (this.loadedClasses.contains(name)) {
            return;
        }
        this.loadedClasses.add(name);
        try {
            bytes = Launch.classLoader.getClassBytes(name);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (bytes != null) {
            ClassReader reader = new ClassReader(bytes);
            this.createSuperMaps(reader, name, reader.getSuperName(), reader.getInterfaces());
        }
    }

    private void addInheritedMembers(String parent, Map<String, String> fields, Map<String, String> methods) {
        this.loadSuperMaps(parent);
        Map<String, String> m = this.fields.get(parent);
        if (m != null) {
            fields.putAll(m);
        }
        if ((m = this.methods.get(parent)) != null) {
            methods.putAll(m);
        }
    }

    private void createSuperMaps(ClassReader reader, String name, @Nullable String superName, @Nullable String[] interfaces) {
        ImmutableMap raw;
        this.loadedClasses.add(name);
        HashMap<String, String> fields = new HashMap<String, String>();
        HashMap<String, String> methods = new HashMap<String, String>();
        if (superName != null) {
            this.addInheritedMembers(superName, fields, methods);
        }
        if (interfaces != null) {
            for (String parent : interfaces) {
                this.addInheritedMembers(parent, fields, methods);
            }
        }
        if (!(raw = this.rawFields.row((Object)name)).isEmpty()) {
            ClassNode classNode = new ClassNode();
            reader.accept(classNode, 7);
            for (FieldNode fieldNode : classNode.fields) {
                String newName = (String)raw.get(fieldNode.name);
                if (newName == null) continue;
                fields.put(fieldNode.name + ':' + fieldNode.desc, newName);
            }
        }
        methods.putAll((Map<String, String>)this.rawMethods.row((Object)name));
        this.fields.put(name, (Map<String, String>)ImmutableMap.copyOf(fields));
        this.methods.put(name, (Map<String, String>)ImmutableMap.copyOf(methods));
    }

    @Override
    ClassVisitor createClassRemapper(ClassReader reader, ClassVisitor cv) {
        return new NotchClassRemapper(reader, cv);
    }

    private class NotchClassRemapper
    extends ClassRemapper {
        private final ClassReader reader;

        private NotchClassRemapper(ClassReader reader, ClassVisitor cv) {
            super(327680, cv, NotchDeobfuscationTransformer.this);
            this.reader = reader;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            NotchDeobfuscationTransformer.this.createSuperMaps(this.reader, name, superName, interfaces);
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }
}

