/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.deobf.reader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;

public final class McpCsvReader {
    private static final Splitter CSV_SPLITTER = Splitter.on((char)',').limit(3);
    private final ImmutableMap.Builder<String, String> fields = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, String> methods = ImmutableMap.builder();

    public void read(Path dir) throws IOException {
        this.read(dir.resolve(MappingType.FIELD.file), MappingType.FIELD);
        this.read(dir.resolve(MappingType.METHOD.file), MappingType.METHOD);
    }

    public void read(Path file, MappingType type) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            this.read(reader, type);
        }
    }

    public void read(BufferedReader reader, MappingType type) throws IOException {
        switch (type) {
            case FIELD: {
                this.read(reader, type, this.fields);
                break;
            }
            case METHOD: {
                this.read(reader, type, this.methods);
            }
        }
    }

    private void read(BufferedReader reader, MappingType type, ImmutableMap.Builder<String, String> builder) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!(line = line.trim()).startsWith(type.prefix)) continue;
            Iterator parts = CSV_SPLITTER.split((CharSequence)line).iterator();
            builder.put(parts.next(), parts.next());
        }
    }

    public ImmutableMap<String, String> getFields() {
        return this.fields.build();
    }

    public ImmutableMap<String, String> getMethods() {
        return this.methods.build();
    }

    public static enum MappingType {
        METHOD("func_", "methods.csv"),
        FIELD("field_", "fields.csv");

        private final String prefix;
        private final String file;

        private MappingType(String prefix, String file) {
            this.prefix = prefix;
            this.file = file;
        }
    }
}

