/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.deobf.reader;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public final class SrgReader {
    private static final char SEPARATOR = ' ';
    private static final Splitter SEPARATOR_SPLITTER = Splitter.on((char)' ');
    private static final char KEY_SEPARATOR = ':';
    private static final String CLASS_MAPPING_KEY = "CL";
    private static final String FIELD_MAPPING_KEY = "FD";
    private static final String METHOD_MAPPING_KEY = "MD";
    private static final char MEMBER_SEPARATOR = '/';
    private static final int MIN_LINE_LENGTH = 7;
    private final ImmutableBiMap.Builder<String, String> classes = ImmutableBiMap.builder();
    private final ImmutableTable.Builder<String, String, String> fields = ImmutableTable.builder();
    private final ImmutableTable.Builder<String, String, String> methods = ImmutableTable.builder();

    public void read(URL resource) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
            this.read(reader);
        }
    }

    public void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String[] source;
            if ((line = line.trim()).length() < 7 || line.charAt(2) != ':' || line.charAt(3) != ' ') continue;
            Iterator parts = SEPARATOR_SPLITTER.split((CharSequence)line).iterator();
            String prefix = (String)parts.next();
            if (prefix.startsWith(CLASS_MAPPING_KEY)) {
                this.classes.put(parts.next(), parts.next());
                continue;
            }
            if (prefix.startsWith(FIELD_MAPPING_KEY)) {
                source = SrgReader.parseMember((String)parts.next());
                String[] mapped = SrgReader.parseMember((String)parts.next());
                this.fields.put((Object)source[0], (Object)source[1], (Object)mapped[1]);
                continue;
            }
            if (!prefix.startsWith(METHOD_MAPPING_KEY)) continue;
            source = SrgReader.parseMember((String)parts.next());
            String desc = (String)parts.next();
            String[] mapped = SrgReader.parseMember((String)parts.next());
            this.methods.put((Object)source[0], (Object)source[1].concat(desc), (Object)mapped[1]);
        }
    }

    private static String[] parseMember(String member) {
        int pos = member.lastIndexOf(47);
        return new String[]{member.substring(0, pos), member.substring(pos + 1)};
    }

    public ImmutableBiMap<String, String> getClasses() {
        return this.classes.build();
    }

    public ImmutableTable<String, String, String> getFields() {
        return this.fields.build();
    }

    public ImmutableTable<String, String, String> getMethods() {
        return this.methods.build();
    }
}

