/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.entity.IMixinEntity;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IMixinEntity {
    @Nullable
    private NBTTagCompound customEntityData;

    @Inject(method="<init>(Lnet/minecraft/world/World;)V", at={@At(value="RETURN")}, remap=false)
    private void onConstructed(World world, CallbackInfo ci) {
        SpongeImpl.postEvent(SpongeEventFactory.createConstructEntityEventPost(Cause.of(NamedCause.source(world)), this, this.getType(), this.getTransform()));
    }

    @Override
    public final NBTTagCompound getEntityData() {
        if (this.customEntityData == null) {
            this.customEntityData = new NBTTagCompound();
        }
        return this.customEntityData;
    }

    @Inject(method="readFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V", at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;readEntityFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V")})
    private void preReadFromNBTInject(NBTTagCompound tagCompound, CallbackInfo ci) {
        if (tagCompound.func_74764_b("ForgeData")) {
            this.customEntityData = tagCompound.func_74775_l("ForgeData");
        }
    }

    @Inject(method="writeToNBT(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;writeEntityToNBT(Lnet/minecraft/nbt/NBTTagCompound;)V")})
    private void preWriteToNBTInject(NBTTagCompound tagCompound, CallbackInfoReturnable<NBTTagCompound> ci) {
        if (this.customEntityData != null) {
            tagCompound.func_74782_a("ForgeData", (NBTBase)this.customEntityData);
        }
    }
}

