/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.server.dedicated;

import java.io.IOException;
import jline.console.ConsoleReader;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.serializer.LegacyTexts;
import org.spongepowered.server.console.ConsoleCommandCompleter;
import org.spongepowered.server.console.ConsoleFormatter;
import org.spongepowered.server.launch.console.TerminalConsoleAppender;

@Mixin(targets={"net/minecraft/server/dedicated/DedicatedServer$2"})
public abstract class MixinConsoleHandler {
    @Shadow(remap=false, aliases={"field_72428_a", "this$0"})
    @Final
    private DedicatedServer server;

    @Inject(method="run", at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onRun(CallbackInfo ci) {
        ConsoleReader reader = TerminalConsoleAppender.getReader();
        if (reader != null) {
            TerminalConsoleAppender.setFormatter(ConsoleFormatter::format);
            reader.addCompleter(new ConsoleCommandCompleter(this.server));
            reader.setPrompt("> ");
            while (!this.server.func_71241_aa() && this.server.func_71278_l()) {
                try {
                    String line = reader.readLine();
                    if (line == null) break;
                    if ((line = line.trim()).isEmpty()) continue;
                    this.server.func_71331_a(line, (ICommandSender)this.server);
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("Exception handling console input", (Throwable)e);
                }
            }
            ci.cancel();
        } else {
            TerminalConsoleAppender.setFormatter(s -> LegacyTexts.strip(s, '\u00a7'));
        }
    }
}

