/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.plugin;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.guice.SpongePluginGuiceModule;
import org.spongepowered.common.plugin.AbstractPluginContainer;
import org.spongepowered.common.plugin.PluginContainerExtension;

final class VanillaPluginContainer
extends AbstractPluginContainer
implements PluginContainerExtension {
    private final String id;
    private final Optional<String> name;
    private final Optional<String> version;
    private final Optional<String> description;
    private final Optional<String> url;
    private final Optional<String> minecraftVersion;
    private final ImmutableList<String> authors;
    private final Optional<Path> source;
    private final Optional<?> instance;
    private final Logger logger;
    private final Injector injector;

    VanillaPluginContainer(String id, Class<?> pluginClass, @Nullable String name, @Nullable String version, @Nullable String description, @Nullable String url, @Nullable String minecraftVersion, List<String> authors, Optional<Path> source) {
        this.id = id;
        this.name = Optional.ofNullable(name);
        this.version = Optional.ofNullable(version);
        this.description = Optional.ofNullable(description);
        this.url = Optional.ofNullable(url);
        this.minecraftVersion = Optional.ofNullable(minecraftVersion);
        this.authors = ImmutableList.copyOf(authors);
        this.source = source;
        this.logger = LoggerFactory.getLogger(this.id);
        this.injector = SpongeImpl.getInjector().createChildInjector(new SpongePluginGuiceModule(this, pluginClass));
        this.instance = Optional.of(this.injector.getInstance(pluginClass));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name.orElse(this.id);
    }

    @Override
    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    public Optional<String> getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public Optional<Path> getSource() {
        return this.source;
    }

    @Override
    public Optional<?> getInstance() {
        return this.instance;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public Optional<Asset> getAsset(String name) {
        return Sponge.getAssetManager().getAsset(this, name);
    }
}

