/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.util.Arrays;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class ByteArrayParameter
implements Cloneable,
ParameterHolder {
    private byte[] bytes;
    private boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(BINARY_INTRODUCER);
        pos.writeBytesEscaped(this.bytes, this.bytes.length, this.noBackslashEscapes);
        pos.write(39);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.bytes.length * 2;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeFieldLength(this.bytes.length);
        pos.write(this.bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARSTRING;
    }

    @Override
    public String toString() {
        if (this.bytes.length > 1024) {
            return "<bytearray:" + new String(Arrays.copyOfRange(this.bytes, 0, 1024)) + "...>";
        }
        return "<bytearray:" + new String(this.bytes) + ">";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

