/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.property.PropertyRegistry;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.service.ServiceManager;
import org.spongepowered.api.world.TeleportHelper;

public final class Sponge {
    @Inject
    private static Game game;
    @Inject
    private static Platform platform;
    @Inject
    private static GameRegistry registry;
    @Inject
    private static DataManager dataManager;
    @Inject
    private static PropertyRegistry propertyRegistry;
    @Inject
    private static PluginManager pluginManager;
    @Inject
    private static EventManager eventManager;
    @Inject
    private static AssetManager assetManager;
    @Inject
    private static ConfigManager configManager;
    @Inject
    private static CommandManager commandManager;
    @Inject
    private static ServiceManager serviceManager;
    @Inject
    private static Scheduler scheduler;
    @Inject
    private static ChannelRegistrar channelRegistrar;
    @Inject
    private static TeleportHelper teleportHelper;
    @Inject
    private static CauseStackManager causeStackManager;

    private static <T> T check(@Nullable T instance) {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Sponge has not been initialized!");
        return instance;
    }

    public static Game getGame() {
        return Sponge.check(game);
    }

    public static Platform getPlatform() {
        return Sponge.check(platform);
    }

    public static GameRegistry getRegistry() {
        return Sponge.check(registry);
    }

    public static DataManager getDataManager() {
        return Sponge.check(dataManager);
    }

    public static PropertyRegistry getPropertyRegistry() {
        return Sponge.check(propertyRegistry);
    }

    public static PluginManager getPluginManager() {
        return Sponge.check(pluginManager);
    }

    public static EventManager getEventManager() {
        return Sponge.check(eventManager);
    }

    public static AssetManager getAssetManager() {
        return Sponge.check(assetManager);
    }

    public static ConfigManager getConfigManager() {
        return Sponge.check(configManager);
    }

    public static CommandManager getCommandManager() {
        return Sponge.check(commandManager);
    }

    public static ServiceManager getServiceManager() {
        return Sponge.check(serviceManager);
    }

    public static Scheduler getScheduler() {
        return Sponge.check(scheduler);
    }

    public static ChannelRegistrar getChannelRegistrar() {
        return Sponge.check(channelRegistrar);
    }

    public static TeleportHelper getTeleportHelper() {
        return Sponge.check(teleportHelper);
    }

    public static boolean isServerAvailable() {
        return Sponge.getGame().isServerAvailable();
    }

    public static Server getServer() {
        return Sponge.getGame().getServer();
    }

    public static Optional<GameDictionary> getDictionary() {
        return Sponge.getGame().getGameDictionary();
    }

    public static CauseStackManager getCauseStackManager() {
        return Sponge.check(causeStackManager);
    }
}

