/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKey;

public interface CauseStackManager {
    public Cause getCurrentCause();

    public EventContext getCurrentContext();

    public CauseStackManager pushCause(Object var1);

    public Object popCause();

    public void popCauses(int var1);

    public Object peekCause();

    public StackFrame pushCauseFrame();

    public void popCauseFrame(StackFrame var1);

    public <T> CauseStackManager addContext(EventContextKey<T> var1, T var2);

    public <T> Optional<T> getContext(EventContextKey<T> var1);

    default public <T> T requireContext(EventContextKey<T> key) {
        Optional<T> optional = this.getContext(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.getId()));
    }

    public <T> Optional<T> removeContext(EventContextKey<T> var1);

    public static interface StackFrame
    extends AutoCloseable {
        @Override
        public void close();
    }
}

