/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.api.util.ResettableBuilder;

public final class EventContext {
    private static final EventContext EMPTY_CONTEXT = new EventContext((Map<EventContextKey<?>, Object>)ImmutableMap.of());
    private final Map<EventContextKey<?>, Object> entries;

    public static EventContext empty() {
        return EMPTY_CONTEXT;
    }

    public static EventContext of(Map<EventContextKey<?>, Object> entries) {
        Preconditions.checkNotNull(entries, (Object)"Context entries cannot be null");
        for (Map.Entry<EventContextKey<?>, Object> entry : entries.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getValue(), (Object)"Entries cannot contain null values");
        }
        return new EventContext(entries);
    }

    public static Builder builder() {
        return new Builder();
    }

    EventContext(Map<EventContextKey<?>, Object> values) {
        this.entries = ImmutableMap.copyOf(values);
    }

    public <T> Optional<T> get(EventContextKey<T> key) {
        Preconditions.checkNotNull(key, (Object)"EventContextKey cannot be null");
        return Optional.ofNullable(this.entries.get(key));
    }

    public <T> T require(EventContextKey<T> key) {
        Optional<T> optional = this.get(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.getId()));
    }

    public boolean containsKey(EventContextKey<?> key) {
        return this.entries.containsKey(key);
    }

    public Set<EventContextKey<?>> keySet() {
        return this.entries.keySet();
    }

    public Map<EventContextKey<?>, Object> asMap() {
        return this.entries;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EventContext)) {
            return false;
        }
        EventContext ctx = (EventContext)object;
        for (Map.Entry<EventContextKey<?>, Object> entry : this.entries.entrySet()) {
            Object other = ctx.entries.get(entry.getKey());
            if (other == null) {
                return false;
            }
            if (entry.getValue().equals(other)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry<EventContextKey<?>, Object> entry : this.entries.entrySet()) {
            joiner.add("\"" + entry.getKey().getId() + "\"=" + entry.getValue().toString());
        }
        return "Context[" + joiner.toString() + "]";
    }

    public static final class Builder
    implements ResettableBuilder<EventContext, Builder> {
        private final Map<EventContextKey<?>, Object> entries = Maps.newHashMap();

        Builder() {
        }

        public <T> Builder add(EventContextKey<T> key, T value) {
            Preconditions.checkNotNull(value, (Object)"Context object cannot be null");
            Preconditions.checkArgument((!this.entries.containsKey(key) ? 1 : 0) != 0, (Object)"Duplicate context keys");
            this.entries.put(key, value);
            return this;
        }

        @Override
        public Builder from(EventContext value) {
            this.entries.putAll(value.entries);
            return this;
        }

        @Override
        public Builder reset() {
            this.entries.clear();
            return this;
        }

        public EventContext build() {
            return new EventContext(this.entries);
        }
    }
}

