/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class Context
implements Map.Entry<String, String> {
    public static final String USER_KEY = "user";
    public static final String WORLD_KEY = "world";
    public static final String DIMENSION_KEY = "dimension";
    public static final String REMOTE_IP_KEY = "remoteip";
    public static final String LOCAL_HOST_KEY = "localhost";
    public static final String LOCAL_IP_KEY = "localip";
    public static final String LOCAL_PORT_KEY = "localport";
    private final Map.Entry<String, String> wrapped;

    public Context(String type, String name) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.wrapped = Maps.immutableEntry((Object)type, (Object)name);
    }

    public String getType() {
        return this.getKey();
    }

    public String getName() {
        return this.getValue();
    }

    @Override
    public String getKey() {
        return this.wrapped.getKey();
    }

    @Override
    public String getValue() {
        return this.wrapped.getValue();
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException("Contexts are immutable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Map.Entry && this.wrapped.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

