/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;

public final class ScoreText
extends Text {
    final Score score;
    final Optional<String> override;

    ScoreText(Score score) {
        this.score = (Score)Preconditions.checkNotNull((Object)score, (Object)"score");
        this.override = Optional.empty();
    }

    ScoreText(TextFormat format, ImmutableList<Text> children, @Nullable ClickAction<?> clickAction, @Nullable HoverAction<?> hoverAction, @Nullable ShiftClickAction<?> shiftClickAction, Score score, @Nullable String override) {
        super(format, children, clickAction, hoverAction, shiftClickAction);
        this.score = (Score)Preconditions.checkNotNull((Object)score, (Object)"score");
        this.override = Optional.ofNullable(override);
    }

    public Score getScore() {
        return this.score;
    }

    public Optional<String> getOverride() {
        return this.override;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScoreText) || !super.equals(o)) {
            return false;
        }
        ScoreText that = (ScoreText)o;
        return this.score.equals(that.score) && this.override.equals(that.override);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.score, this.override});
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().addValue((Object)this.score).add("override", this.override.orElse(null));
    }

    public static class Builder
    extends Text.Builder {
        private Score score;
        @Nullable
        private String override;

        Builder(Score score) {
            this.score(score);
        }

        Builder(Text text, Score score) {
            super(text);
            this.score(score);
        }

        Builder(ScoreText text) {
            super(text);
            this.score = text.score;
            this.override = text.override.orElse(null);
        }

        public final Score getScore() {
            return this.score;
        }

        public Builder score(Score score) {
            this.score = (Score)Preconditions.checkNotNull((Object)score, (Object)"score");
            return this;
        }

        public final Optional<String> getOverride() {
            return Optional.ofNullable(this.override);
        }

        public Builder override(@Nullable String override) {
            this.override = override;
            return this;
        }

        @Override
        public ScoreText build() {
            return new ScoreText(this.format, (ImmutableList<Text>)ImmutableList.copyOf((Collection)this.children), this.clickAction, this.hoverAction, this.shiftClickAction, this.score, this.override);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder) || !super.equals(o)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal((Object)this.score, (Object)that.score) && Objects.equal((Object)this.override, (Object)that.override);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.score, this.override});
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().addValue((Object)this.score).add("override", (Object)this.override);
        }

        @Override
        public Builder format(TextFormat format) {
            return (Builder)super.format(format);
        }

        @Override
        public Builder color(TextColor color) {
            return (Builder)super.color(color);
        }

        @Override
        public Builder style(TextStyle ... styles) {
            return (Builder)super.style(styles);
        }

        @Override
        public Builder onClick(@Nullable ClickAction<?> clickAction) {
            return (Builder)super.onClick(clickAction);
        }

        @Override
        public Builder onHover(@Nullable HoverAction<?> hoverAction) {
            return (Builder)super.onHover(hoverAction);
        }

        @Override
        public Builder onShiftClick(@Nullable ShiftClickAction<?> shiftClickAction) {
            return (Builder)super.onShiftClick(shiftClickAction);
        }

        @Override
        public Builder append(Text ... children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Collection<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterable<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterator<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder insert(int pos, Text ... children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Collection<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterable<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterator<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder remove(Text ... children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Collection<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterable<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterator<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder removeAll() {
            return (Builder)super.removeAll();
        }
    }
}

