/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.util.launchwrapper.LaunchClassLoaderUtil;
import org.spongepowered.asm.util.perf.Profiler;

abstract class TreeInfo {
    private static final Logger logger = LogManager.getLogger((String)"mixin");
    private static MixinTransformer.ReEntranceState lock;

    TreeInfo() {
    }

    static void setLock(MixinTransformer.ReEntranceState lock) {
        TreeInfo.lock = lock;
    }

    static ClassNode getClassNode(String className) throws ClassNotFoundException, IOException {
        return TreeInfo.getClassNode(TreeInfo.loadClass(className, true), 0);
    }

    static ClassNode getClassNode(byte[] classBytes, int flags) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept(classNode, flags);
        return classNode;
    }

    static byte[] loadClass(String className, boolean runTransformers) throws ClassNotFoundException, IOException {
        String transformedName = className.replace('/', '.');
        String name = MixinEnvironment.getCurrentEnvironment().unmap(transformedName);
        Profiler profiler = MixinEnvironment.getProfiler();
        Profiler.Section loadTime = profiler.begin(1, "class.load");
        byte[] classBytes = TreeInfo.getClassBytes(name, transformedName);
        loadTime.end();
        if (runTransformers) {
            Profiler.Section transformTime = profiler.begin(1, "class.transform");
            classBytes = TreeInfo.applyTransformers(name, transformedName, classBytes, profiler);
            transformTime.end();
        }
        if (classBytes == null) {
            throw new ClassNotFoundException(String.format("The specified class '%s' was not found", transformedName));
        }
        return classBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getClassBytes(String name, String transformedName) throws IOException {
        byte[] classBytes = Launch.classLoader.getClassBytes(name);
        if (classBytes != null) {
            return classBytes;
        }
        URLClassLoader appClassLoader = (URLClassLoader)Launch.class.getClassLoader();
        InputStream classStream = null;
        try {
            String resourcePath = transformedName.replace('.', '/').concat(".class");
            classStream = appClassLoader.getResourceAsStream(resourcePath);
            byte[] byArray = IOUtils.toByteArray((InputStream)classStream);
            IOUtils.closeQuietly((InputStream)classStream);
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(classStream);
        }
    }

    private static byte[] applyTransformers(String name, String transformedName, byte[] basicClass, Profiler profiler) {
        if (LaunchClassLoaderUtil.forClassLoader(Launch.classLoader).isClassExcluded(name, transformedName)) {
            return basicClass;
        }
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        for (IClassTransformer transformer : environment.getTransformers()) {
            if (lock != null) {
                lock.clear();
            }
            Class<?> clazz = transformer.getClass();
            Profiler.Section transformTime = profiler.begin(2, clazz.getSimpleName().toLowerCase());
            transformTime.setInfo(clazz.getName());
            basicClass = transformer.transform(name, transformedName, basicClass);
            transformTime.end();
            if (lock == null || !lock.isSet()) continue;
            environment.addTransformerExclusion(clazz.getName());
            lock.clear();
            logger.info("A re-entrant transformer '{}' was detected and will no longer process meta class data", new Object[]{clazz.getName()});
        }
        return basicClass;
    }
}

