/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.AsyncLightingCategory;
import org.spongepowered.common.config.category.ConfigCategory;
import org.spongepowered.common.config.category.StructureSaveCategory;

@ConfigSerializable
public class OptimizationCategory
extends ConfigCategory {
    private static final String PRE_MERGE_COMMENT = "If enabled, block item drops are pre-processed to avoid \nhaving to spawn extra entities that will be merged post spawning.\nUsually, Sponge is smart enough to determine when to attempt an item pre-merge\nand when not to, however, in certain cases, some mods rely on items not being\npre-merged and actually spawned, in which case, the items will flow right through\nwithout being merged.";
    @Setting(value="drops-pre-merge", comment="If enabled, block item drops are pre-processed to avoid \nhaving to spawn extra entities that will be merged post spawning.\nUsually, Sponge is smart enough to determine when to attempt an item pre-merge\nand when not to, however, in certain cases, some mods rely on items not being\npre-merged and actually spawned, in which case, the items will flow right through\nwithout being merged.")
    private boolean preItemDropMerge;
    @Setting(value="cache-tameable-owners", comment="Caches tameable entities owners to avoid constant lookups against data watchers. If mods cause issue, disable.")
    private boolean cacheTameableOwners = true;
    @Setting(value="structure-saving", comment="Handles structures that are saved to disk. Certain structures can take up large amounts\nof disk space for very large maps and the data for these structures is only needed while the world\naround them is generating. Disabling saving of these structures can save disk space and time during\nsaves if your world is already fully generated.\nWarning: disabling structure saving will break the vanilla locate command.")
    private StructureSaveCategory structureSaveCategory = new StructureSaveCategory();
    @Setting(value="async-lighting", comment="Runs lighting updates async.")
    private AsyncLightingCategory asyncLightingCategory = new AsyncLightingCategory();
    @Setting(value="panda-redstone", comment="If enabled, uses Panda4494's Redstone implementation which improves performance.\nSee https://bugs.mojang.com/browse/MC-11193 for more information.\nNote: This optimization has a few issues which is explained in the bug report. We are not responsible for any issues this may cause.")
    private boolean pandaRedstone = false;

    public OptimizationCategory() {
        try {
            this.preItemDropMerge = Launch.classLoader.getClassBytes("net.minecraftforge.common.ForgeVersion") == null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StructureSaveCategory getStructureSaveCategory() {
        return this.structureSaveCategory;
    }

    public boolean useStructureSave() {
        return this.structureSaveCategory.isEnabled();
    }

    public boolean doDropsPreMergeItemDrops() {
        return this.preItemDropMerge;
    }

    public boolean useCacheTameableOwners() {
        return this.cacheTameableOwners;
    }

    public AsyncLightingCategory getAsyncLightingCategory() {
        return this.asyncLightingCategory;
    }

    public boolean useAsyncLighting() {
        return this.asyncLightingCategory.isEnabled();
    }

    public boolean usePandaRedstone() {
        return this.pandaRedstone;
    }
}

