/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableVariantData;
import org.spongepowered.api.data.manipulator.mutable.VariantData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableSingleCatalogData<E extends CatalogType, I extends ImmutableVariantData<E, I, M>, M extends VariantData<E, M, I>>
extends AbstractImmutableSingleData<E, I, M>
implements ImmutableVariantData<E, I, M> {
    private final Class<? extends M> mutableClass;
    private final E defaultValue;
    private final ImmutableValue<E> immutableValue;

    public AbstractImmutableSingleCatalogData(Class<I> immutableClass, E value, E defaultValue, Key<? extends BaseValue<E>> usedKey, Class<? extends M> mutableClass) {
        super(immutableClass, value, usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.mutableClass = (Class)Preconditions.checkNotNull(mutableClass);
        this.defaultValue = (CatalogType)Preconditions.checkNotNull(defaultValue, (Object)"The default value was null! This is unacceptable! Maybe the value was not registered?");
        this.immutableValue = ImmutableSpongeValue.cachedOf(this.usedKey, this.defaultValue, this.value);
    }

    @Override
    protected ImmutableValue<E> getValueGetter() {
        return this.immutableValue;
    }

    @Override
    public M asMutable() {
        return (M)((VariantData)ReflectionUtil.createInstance(this.mutableClass, this.getValue()));
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), (Object)((CatalogType)this.value).getId());
    }

    @Override
    public ImmutableValue<E> type() {
        return this.immutableValue;
    }
}

