/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMovementSpeedData;
import org.spongepowered.api.data.manipulator.mutable.entity.MovementSpeedData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeMovementSpeedData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeMovementSpeedData
extends AbstractImmutableData<ImmutableMovementSpeedData, MovementSpeedData>
implements ImmutableMovementSpeedData {
    private final double walkSpeed;
    private final double flySpeed;
    private final ImmutableValue<Double> walkSpeedValue;
    private final ImmutableValue<Double> flyingSpeedValue;

    public ImmutableSpongeMovementSpeedData(double walkSpeed, double flySpeed) {
        super(ImmutableMovementSpeedData.class);
        this.walkSpeed = walkSpeed;
        this.flySpeed = flySpeed;
        this.walkSpeedValue = new ImmutableSpongeValue<Double>(Keys.WALKING_SPEED, 0.7, this.walkSpeed);
        this.flyingSpeedValue = new ImmutableSpongeValue<Double>(Keys.FLYING_SPEED, 0.05, this.flySpeed);
        this.registerGetters();
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public double getFlySpeed() {
        return this.flySpeed;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.WALKING_SPEED, this::getWalkSpeed);
        this.registerKeyValue(Keys.WALKING_SPEED, this::walkSpeed);
        this.registerFieldGetter(Keys.FLYING_SPEED, this::getFlySpeed);
        this.registerKeyValue(Keys.FLYING_SPEED, this::flySpeed);
    }

    @Override
    public ImmutableValue<Double> walkSpeed() {
        return this.walkSpeedValue;
    }

    @Override
    public ImmutableValue<Double> flySpeed() {
        return this.flyingSpeedValue;
    }

    @Override
    public MovementSpeedData asMutable() {
        return new SpongeMovementSpeedData(this.walkSpeed, this.flySpeed);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.WALKING_SPEED.getQuery(), (Object)this.walkSpeed).set(Keys.FLYING_SPEED.getQuery(), (Object)this.flySpeed);
    }
}

