/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableTameableData;
import org.spongepowered.api.data.manipulator.mutable.entity.TameableData;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeTameableData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;

public class ImmutableSpongeTameableData
extends AbstractImmutableData<ImmutableTameableData, TameableData>
implements ImmutableTameableData {
    private static final ImmutableSpongeOptionalValue<UUID> EMPTY_VALUE = new ImmutableSpongeOptionalValue(Keys.TAMED_OWNER, Optional.empty());
    private static final ImmutableSpongeTameableData EMPTY_DATA = new ImmutableSpongeTameableData(null);
    @Nullable
    private final UUID owner;
    private final ImmutableOptionalValue<UUID> immutableValue;

    public ImmutableSpongeTameableData(@Nullable UUID owner) {
        super(ImmutableTameableData.class);
        this.owner = owner;
        this.immutableValue = this.owner == null ? EMPTY_VALUE : new ImmutableSpongeOptionalValue<UUID>(Keys.TAMED_OWNER, Optional.of(this.owner));
        this.registerGetters();
    }

    @Override
    public ImmutableOptionalValue<UUID> owner() {
        return this.immutableValue;
    }

    @Override
    public TameableData asMutable() {
        return new SpongeTameableData(this.owner);
    }

    @Override
    public DataContainer toContainer() {
        String owner = this.owner == null ? "none" : this.owner.toString();
        return super.toContainer().set(Keys.TAMED_OWNER.getQuery(), (Object)owner);
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.TAMED_OWNER, this::getOwner);
        this.registerKeyValue(Keys.TAMED_OWNER, this::owner);
    }

    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public static ImmutableTameableData create(@Nullable UUID owner) {
        if (owner == null) {
            return EMPTY_DATA;
        }
        return new ImmutableSpongeTameableData(owner);
    }

    public static ImmutableSpongeOptionalValue<UUID> createValue(Optional<UUID> owner) {
        if (!owner.isPresent()) {
            return EMPTY_VALUE;
        }
        return new ImmutableSpongeOptionalValue<UUID>(Keys.TAMED_OWNER, owner);
    }
}

