/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.tileentity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableFurnaceData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.FurnaceData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeFurnaceData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeFurnaceData
extends AbstractImmutableData<ImmutableFurnaceData, FurnaceData>
implements ImmutableFurnaceData {
    private final int passedBurnTime;
    private final int maxBurnTime;
    private final int passedCookTime;
    private final int maxCookTime;
    private final ImmutableBoundedValue<Integer> passedBurnTimeValue;
    private final ImmutableBoundedValue<Integer> maxBurnTimeValue;
    private final ImmutableBoundedValue<Integer> passedCookTimeValue;
    private final ImmutableBoundedValue<Integer> maxCookTimeValue;

    public ImmutableSpongeFurnaceData(int passedBurnTime, int maxBurnTime, int passedCookTime, int maxCookTime) {
        super(ImmutableFurnaceData.class);
        this.passedBurnTime = passedBurnTime;
        this.maxBurnTime = maxBurnTime;
        this.passedCookTime = passedCookTime;
        this.maxCookTime = maxCookTime;
        this.passedBurnTimeValue = SpongeValueFactory.boundedBuilder(Keys.PASSED_BURN_TIME).minimum(0).maximum(this.maxBurnTime).defaultValue(0).actualValue(this.passedBurnTime).build().asImmutable();
        this.maxBurnTimeValue = SpongeValueFactory.boundedBuilder(Keys.MAX_BURN_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(1600).actualValue(this.maxBurnTime).build().asImmutable();
        this.passedCookTimeValue = SpongeValueFactory.boundedBuilder(Keys.PASSED_COOK_TIME).minimum(0).maximum(this.maxCookTime).defaultValue(0).actualValue(this.passedCookTime).build().asImmutable();
        this.maxCookTimeValue = SpongeValueFactory.boundedBuilder(Keys.MAX_COOK_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(200).actualValue(this.maxCookTime).build().asImmutable();
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.PASSED_BURN_TIME, this::getPassedBurnTime);
        this.registerKeyValue(Keys.PASSED_BURN_TIME, this::passedBurnTime);
        this.registerFieldGetter(Keys.MAX_BURN_TIME, this::getMaxBurnTime);
        this.registerKeyValue(Keys.MAX_BURN_TIME, this::maxBurnTime);
        this.registerFieldGetter(Keys.PASSED_COOK_TIME, this::getPassedCookTime);
        this.registerKeyValue(Keys.PASSED_COOK_TIME, this::passedCookTime);
        this.registerFieldGetter(Keys.MAX_COOK_TIME, this::getMaxCookTime);
        this.registerKeyValue(Keys.MAX_COOK_TIME, this::maxCookTime);
    }

    @Override
    public ImmutableBoundedValue<Integer> passedBurnTime() {
        return this.passedBurnTimeValue;
    }

    public int getPassedBurnTime() {
        return this.passedBurnTime;
    }

    @Override
    public ImmutableBoundedValue<Integer> maxBurnTime() {
        return this.maxBurnTimeValue;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    @Override
    public ImmutableBoundedValue<Integer> passedCookTime() {
        return this.passedCookTimeValue;
    }

    public int getPassedCookTime() {
        return this.passedCookTime;
    }

    @Override
    public ImmutableBoundedValue<Integer> maxCookTime() {
        return this.maxCookTimeValue;
    }

    public int getMaxCookTime() {
        return this.maxCookTime;
    }

    @Override
    public FurnaceData asMutable() {
        return new SpongeFurnaceData(this.passedBurnTime, this.maxBurnTime, this.passedCookTime, this.maxCookTime);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.PASSED_BURN_TIME, (Object)this.passedBurnTime).set(Keys.MAX_BURN_TIME, (Object)this.maxBurnTime).set(Keys.PASSED_COOK_TIME, (Object)this.passedCookTime).set(Keys.MAX_COOK_TIME, (Object)this.maxCookTime);
    }
}

