/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractSingleEnumData<E extends Enum<E>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<E, M, I> {
    private final Class<? extends I> immutableClass;
    private final E defaultValue;

    protected AbstractSingleEnumData(Class<M> manipulatorClass, E value, Key<? extends BaseValue<E>> usedKey, Class<? extends I> immutableClass, E defaultValue) {
        super(manipulatorClass, value, usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.immutableClass = (Class)Preconditions.checkNotNull(immutableClass);
        this.defaultValue = (Enum)Preconditions.checkNotNull(defaultValue);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), (Object)((Enum)this.getValue()).name());
    }

    @Override
    public M copy() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    public I asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(this.immutableClass, this.getValue());
    }

    @Override
    protected Value<E> getValueGetter() {
        return new SpongeValue<E>(this.usedKey, this.defaultValue, this.getValue());
    }
}

