/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractSingleSetData<E, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<Set<E>, M, I> {
    private final Class<? extends I> immutableClass;

    public AbstractSingleSetData(Class<M> manipulatorClass, Set<E> value, Key<? extends BaseValue<Set<E>>> usedKey, Class<? extends I> immutableClass) {
        super(manipulatorClass, Sets.newHashSet(value), usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.immutableClass = immutableClass;
    }

    @Override
    public Set<E> getValue() {
        return Sets.newHashSet((Iterable)((Iterable)super.getValue()));
    }

    @Override
    public M setValue(Set<E> value) {
        return super.setValue(Sets.newHashSet(value));
    }

    @Override
    protected Value<?> getValueGetter() {
        return new SpongeSetValue(this.usedKey, this.getValue());
    }

    @Override
    public M copy() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    public I asImmutable() {
        return (I)((ImmutableDataManipulator)ReflectionUtil.createInstance(this.immutableClass, this.getValue()));
    }
}

