/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBreathingData;
import org.spongepowered.api.data.manipulator.mutable.entity.BreathingData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeBreathingData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeBreathingData
extends AbstractData<BreathingData, ImmutableBreathingData>
implements BreathingData {
    private int maxAir;
    private int remainingAir;

    public SpongeBreathingData(int maxAir, int remainingAir) {
        super(BreathingData.class);
        this.maxAir = maxAir;
        this.remainingAir = remainingAir;
        this.registerGettersAndSetters();
    }

    public SpongeBreathingData() {
        this(300, 300);
    }

    @Override
    public BreathingData copy() {
        return new SpongeBreathingData(this.maxAir, this.remainingAir);
    }

    @Override
    public ImmutableBreathingData asImmutable() {
        return new ImmutableSpongeBreathingData(this.maxAir, this.remainingAir);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.MAX_AIR.getQuery(), (Object)this.maxAir).set(Keys.REMAINING_AIR.getQuery(), (Object)this.remainingAir);
    }

    @Override
    public MutableBoundedValue<Integer> remainingAir() {
        return SpongeValueFactory.boundedBuilder(Keys.REMAINING_AIR).defaultValue(300).minimum(-20).maximum(Integer.MAX_VALUE).actualValue(this.remainingAir).build();
    }

    @Override
    public MutableBoundedValue<Integer> maxAir() {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_AIR).defaultValue(this.maxAir).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.maxAir).build();
    }

    private int getMaxAir() {
        return this.maxAir;
    }

    private void setMaxAir(int maxAir) {
        this.maxAir = maxAir;
    }

    private int getRemainingAir() {
        return this.remainingAir;
    }

    private void setRemainingAir(int remainingAir) {
        this.remainingAir = remainingAir;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.MAX_AIR, this::getMaxAir);
        this.registerFieldSetter(Keys.MAX_AIR, this::setMaxAir);
        this.registerKeyValue(Keys.MAX_AIR, this::maxAir);
        this.registerFieldGetter(Keys.REMAINING_AIR, this::getRemainingAir);
        this.registerFieldSetter(Keys.REMAINING_AIR, this::setRemainingAir);
        this.registerKeyValue(Keys.REMAINING_AIR, this::remainingAir);
    }
}

