/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;

public class ConfigurateTranslator
implements DataTranslator<ConfigurationNode> {
    private static final ConfigurateTranslator instance = new ConfigurateTranslator();
    private static final TypeToken<ConfigurationNode> TOKEN = TypeToken.of(ConfigurationNode.class);

    private ConfigurateTranslator() {
    }

    public static ConfigurateTranslator instance() {
        return instance;
    }

    private static void populateNode(ConfigurationNode node, DataView container) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        node.setValue(container.getMap(DataQuery.of()).get());
    }

    private static DataContainer translateFromNode(ConfigurationNode node) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        DataContainer dataContainer = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        ConfigurateTranslator.instance().addTo(node, (DataView)dataContainer);
        return dataContainer;
    }

    private static void translateMapOrList(ConfigurationNode node, DataView container) {
        Object value = node.getValue();
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                container.set(DataQuery.of('.', entry.getKey().toString()), entry.getValue());
            }
        } else if (value != null) {
            container.set(DataQuery.of(node.getKey().toString()), value);
        }
    }

    public ConfigurationNode translateData(DataView container) {
        SimpleConfigurationNode node = SimpleConfigurationNode.root();
        this.translateContainerToData(node, container);
        return node;
    }

    public void translateContainerToData(ConfigurationNode node, DataView container) {
        ConfigurateTranslator.populateNode(node, container);
    }

    public DataContainer translateFrom(ConfigurationNode node) {
        return ConfigurateTranslator.translateFromNode(node);
    }

    @Override
    public TypeToken<ConfigurationNode> getToken() {
        return TOKEN;
    }

    @Override
    public ConfigurationNode translate(DataView view) throws InvalidDataException {
        SimpleConfigurationNode node = SimpleConfigurationNode.root();
        ConfigurateTranslator.populateNode(node, view);
        return node;
    }

    @Override
    public DataContainer translate(ConfigurationNode obj) throws InvalidDataException {
        return ConfigurateTranslator.translateFromNode(obj);
    }

    @Override
    public DataView addTo(ConfigurationNode node, DataView dataView) {
        Object value = node.getValue();
        Object key = node.getKey();
        if (value != null) {
            if (key == null || value instanceof Map || value instanceof List) {
                ConfigurateTranslator.translateMapOrList(node, dataView);
            } else {
                dataView.set(DataQuery.of('.', key.toString()), value);
            }
        }
        return dataView;
    }

    @Override
    public String getId() {
        return "sponge:configuration_node";
    }

    @Override
    public String getName() {
        return "ConfigurationNodeTranslator";
    }
}

