/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.processor.common.AbstractMultiDataProcessor;

public abstract class AbstractMultiDataSingleTargetProcessor<Holder, T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>>
extends AbstractMultiDataProcessor<T, I> {
    protected final Class<Holder> holderClass;

    public AbstractMultiDataSingleTargetProcessor(Class<Holder> holderClass) {
        this.holderClass = (Class)Preconditions.checkNotNull(holderClass);
    }

    @Override
    public boolean supports(DataHolder dataHolder) {
        return this.holderClass.isInstance(dataHolder) && this.supports((Holder)dataHolder);
    }

    protected boolean supports(Holder dataHolder) {
        return true;
    }

    protected abstract boolean doesDataExist(Holder var1);

    protected abstract boolean set(Holder var1, Map<Key<?>, Object> var2);

    protected abstract Map<Key<?>, ?> getValues(Holder var1);

    @Override
    public Optional<T> from(DataHolder dataHolder) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        if (this.doesDataExist(dataHolder)) {
            Object manipulator = this.createManipulator();
            Map<Key<?>, ?> keyValues = this.getValues(dataHolder);
            for (Map.Entry<Key<?>, ?> entry : keyValues.entrySet()) {
                manipulator.set(entry.getKey(), entry.getValue());
            }
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult set(DataHolder dataHolder, T manipulator, MergeFunction function) {
        if (this.supports(dataHolder)) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<T> old = this.from(dataHolder);
            DataManipulator merged = (DataManipulator)((MergeFunction)Preconditions.checkNotNull((Object)function)).merge(old.orElse(null), manipulator);
            IdentityHashMap map = new IdentityHashMap();
            Set<ImmutableValue<?>> newValues = merged.getValues();
            for (ImmutableValue<?> value : newValues) {
                map.put(value.getKey(), value.get());
            }
            try {
                if (this.set(dataHolder, map)) {
                    if (old.isPresent()) {
                        builder.replace(((DataManipulator)old.get()).getValues());
                    }
                    return builder.result(DataTransactionResult.Type.SUCCESS).success(newValues).build();
                }
                return builder.result(DataTransactionResult.Type.FAILURE).reject(newValues).build();
            }
            catch (Exception e) {
                SpongeImpl.getLogger().debug("An exception occurred when setting data: ", (Throwable)e);
                return builder.result(DataTransactionResult.Type.ERROR).reject(newValues).build();
            }
        }
        return DataTransactionResult.failResult(manipulator.getValues());
    }

    @Override
    public Optional<I> with(Key<? extends BaseValue<?>> key, Object value, I immutable) {
        if (immutable.supports(key)) {
            return Optional.of(immutable.asMutable().set(key, (Object)value).asImmutable());
        }
        return Optional.empty();
    }
}

