/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.common.SpongeImpl;

public final class BreakablePlaceableUtils {
    public static boolean set(ItemStack stack, String nbtKey, Set<BlockType> value) {
        NBTTagCompound stackTag = stack.func_77978_p();
        if (value.isEmpty()) {
            if (stackTag != null) {
                stackTag.func_82580_o(nbtKey);
                if (stackTag.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            NBTTagList breakableIds = new NBTTagList();
            for (BlockType breakable : value) {
                String id = breakable.getId();
                if (id.startsWith("minecraft:")) {
                    id = id.substring("minecraft:".length());
                }
                breakableIds.func_74742_a((NBTBase)new NBTTagString(id));
            }
            if (stackTag == null) {
                stackTag = new NBTTagCompound();
                stack.func_77982_d(stackTag);
            }
            stackTag.func_74782_a(nbtKey, (NBTBase)breakableIds);
        }
        return true;
    }

    public static Optional<Set<BlockType>> get(ItemStack stack, String nbtKey) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return Optional.empty();
        }
        NBTTagList blockIds = tag.func_150295_c(nbtKey, 8);
        if (blockIds.func_82582_d()) {
            return Optional.empty();
        }
        HashSet blockTypes = Sets.newHashSetWithExpectedSize((int)blockIds.func_74745_c());
        for (int i = 0; i < blockIds.func_74745_c(); ++i) {
            Optional<BlockType> blockType = SpongeImpl.getGame().getRegistry().getType(BlockType.class, blockIds.func_150307_f(i));
            if (!blockType.isPresent()) continue;
            blockTypes.add(blockType.get());
        }
        return Optional.of(blockTypes);
    }
}

