/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableDyeableData;
import org.spongepowered.api.data.manipulator.mutable.DyeableData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeDyeableData;
import org.spongepowered.common.data.manipulator.mutable.SpongeDyeableData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataProcessor;

public class DyeableDataProcessor
extends AbstractSingleDataProcessor<DyeColor, Value<DyeColor>, DyeableData, ImmutableDyeableData> {
    public DyeableDataProcessor() {
        super(Keys.DYE_COLOR);
    }

    public static boolean isDyeable(Item item) {
        if (item.equals(Items.field_151100_aR)) {
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        return block != null && (block.equals(Blocks.field_150325_L) || block.equals(Blocks.field_150399_cn) || block.equals(Blocks.field_150397_co) || block.equals(Blocks.field_150406_ce));
    }

    @Override
    protected DyeableData createManipulator() {
        return new SpongeDyeableData();
    }

    @Override
    public boolean supports(DataHolder dataHolder) {
        return dataHolder instanceof EntityWolf || dataHolder instanceof EntitySheep || dataHolder instanceof ItemStack && DyeableDataProcessor.isDyeable(((ItemStack)dataHolder).func_77973_b());
    }

    @Override
    public Optional<DyeableData> from(DataHolder dataHolder) {
        if (this.supports(dataHolder)) {
            if (dataHolder instanceof EntitySheep) {
                return Optional.of(new SpongeDyeableData((DyeColor)((EntitySheep)dataHolder).func_175509_cj()));
            }
            if (dataHolder instanceof EntityWolf) {
                return Optional.of(new SpongeDyeableData((DyeColor)((EntityWolf)dataHolder).func_175546_cu()));
            }
            if (dataHolder instanceof ItemStack) {
                if (((ItemStack)dataHolder).func_77973_b().equals(Items.field_151100_aR)) {
                    return Optional.of(new SpongeDyeableData((DyeColor)EnumDyeColor.func_176766_a((int)((ItemStack)dataHolder).func_77952_i())));
                }
                return Optional.of(new SpongeDyeableData((DyeColor)EnumDyeColor.func_176764_b((int)((ItemStack)dataHolder).func_77952_i())));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<DyeableData> fill(DataContainer container, DyeableData dyeableData) {
        Optional<String> id = container.getString(Keys.DYE_COLOR.getQuery());
        if (id.isPresent()) {
            dyeableData.set(Keys.DYE_COLOR, Sponge.getGame().getRegistry().getType(DyeColor.class, id.get()).get());
            return Optional.of(dyeableData);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult set(DataHolder dataHolder, DyeableData manipulator, MergeFunction function) {
        if (this.supports(dataHolder)) {
            DyeableData origin = this.from(dataHolder).get();
            DyeableData merged = ((MergeFunction)Preconditions.checkNotNull((Object)function, (Object)"function")).merge(origin, manipulator);
            if (dataHolder instanceof EntitySheep) {
                ((EntitySheep)dataHolder).func_175512_b((EnumDyeColor)merged.type().get());
                return DataTransactionResult.successReplaceResult(origin.type().asImmutable(), merged.type().asImmutable());
            }
            if (dataHolder instanceof EntityWolf) {
                ((EntityWolf)dataHolder).func_175547_a((EnumDyeColor)merged.type().get());
                return DataTransactionResult.successReplaceResult(origin.type().asImmutable(), merged.type().asImmutable());
            }
            if (dataHolder instanceof ItemStack) {
                if (((ItemStack)dataHolder).func_77973_b().equals(Items.field_151100_aR)) {
                    ((ItemStack)dataHolder).func_77964_b(((EnumDyeColor)merged.type().get()).func_176767_b());
                } else {
                    ((ItemStack)dataHolder).func_77964_b(((EnumDyeColor)merged.type().get()).func_176765_a());
                }
                return DataTransactionResult.successReplaceResult(origin.type().asImmutable(), merged.type().asImmutable());
            }
        }
        return DataTransactionResult.failResult(manipulator.type().asImmutable());
    }

    @Override
    public Optional<ImmutableDyeableData> with(Key<? extends BaseValue<?>> key, Object value, ImmutableDyeableData immutable) {
        if (key.equals(Keys.DYE_COLOR)) {
            return Optional.of(new ImmutableSpongeDyeableData((DyeColor)value));
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

